/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor;

import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkProtectedApi;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallLocation;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.MarshallingType;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.OperationInfo;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.ProtocolRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.StructuredRpcV2CborGenerator;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.StructuredRpcV2CborMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.internal.EmptyBodyRpcV2CborMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.internal.MarshallerRegistry;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.internal.RpcV2CborProtocolMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.internal.SimpleTypeRpcV2CborMarshallers;

@SdkProtectedApi
public class RpcV2CborProtocolMarshallerBuilder<T> {
    private StructuredRpcV2CborGenerator rpcv2cborGenerator;
    private String contentType;
    private OperationInfo operationInfo;
    private T originalRequest;
    private MarshallerRegistry.Builder marshallerRegistry;
    private EmptyBodyRpcV2CborMarshaller emptyBodyMarshaller;
    private boolean hasAwsQueryCompatible;

    public static <T> RpcV2CborProtocolMarshallerBuilder<T> standard() {
        return new RpcV2CborProtocolMarshallerBuilder<T>();
    }

    public RpcV2CborProtocolMarshallerBuilder<T> rpcv2cborGenerator(StructuredRpcV2CborGenerator rpcv2cborGenerator) {
        this.rpcv2cborGenerator = rpcv2cborGenerator;
        return this;
    }

    public RpcV2CborProtocolMarshallerBuilder<T> contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public RpcV2CborProtocolMarshallerBuilder<T> operationInfo(OperationInfo operationInfo) {
        this.operationInfo = operationInfo;
        return this;
    }

    public RpcV2CborProtocolMarshallerBuilder<T> originalRequest(T originalRequest) {
        this.originalRequest = originalRequest;
        return this;
    }

    @Deprecated
    public RpcV2CborProtocolMarshallerBuilder<T> sendExplicitNullForPayload(boolean sendExplicitNullForPayload) {
        return this;
    }

    public RpcV2CborProtocolMarshallerBuilder<T> emptyBodyMarshaller(EmptyBodyRpcV2CborMarshaller emptyBodyMarshaller) {
        this.emptyBodyMarshaller = emptyBodyMarshaller;
        return this;
    }

    public RpcV2CborProtocolMarshallerBuilder<T> withAwsQueryCompatible(boolean hasAwsQueryCompatible) {
        this.hasAwsQueryCompatible = hasAwsQueryCompatible;
        return this;
    }

    public <MarshallT> RpcV2CborProtocolMarshallerBuilder<T> marshallerOverride(MarshallLocation marshallLocation, MarshallingType<MarshallT> marshallingType, StructuredRpcV2CborMarshaller<MarshallT> marshaller) {
        if (this.marshallerRegistry == null) {
            this.marshallerRegistry = MarshallerRegistry.builder();
        }
        this.marshallerRegistry.addMarshaller(marshallLocation, marshallingType, SimpleTypeRpcV2CborMarshallers.adapt(marshaller));
        return this;
    }

    public ProtocolRequestMarshaller<T> build() {
        return new RpcV2CborProtocolMarshaller<T>(this.rpcv2cborGenerator, this.contentType, this.operationInfo, this.originalRequest, this.marshallerRegistry, this.emptyBodyMarshaller, this.hasAwsQueryCompatible);
    }
}

