/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.auth;

import java.io.File;
import java.io.IOException;
import net.snowflake.client.jdbc.internal.amazonaws.SdkClientException;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentials;
import net.snowflake.client.jdbc.internal.amazonaws.auth.AWSCredentialsProvider;
import net.snowflake.client.jdbc.internal.amazonaws.auth.PropertiesCredentials;

public class PropertiesFileCredentialsProvider
implements AWSCredentialsProvider {
    private static final String PROVIDER_NAME = "ProfileCredentialsProvider";
    private final String credentialsFilePath;

    public PropertiesFileCredentialsProvider(String credentialsFilePath) {
        if (credentialsFilePath == null) {
            throw new IllegalArgumentException("Credentials file path cannot be null");
        }
        this.credentialsFilePath = credentialsFilePath;
    }

    @Override
    public AWSCredentials getCredentials() {
        try {
            return new PropertiesCredentials(new File(this.credentialsFilePath), PROVIDER_NAME);
        }
        catch (IOException e) {
            throw new SdkClientException("Unable to load AWS credentials from the " + this.credentialsFilePath + " file", e);
        }
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.credentialsFilePath + ")";
    }
}

