/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc;

import java.io.InputStream;
import java.util.Properties;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SFSession;
import net.snowflake.client.core.SnowflakeOrgInternalApi;
import net.snowflake.client.jdbc.SnowflakeFileTransferMetadata;

@SnowflakeOrgInternalApi
public class SnowflakeFileTransferConfig {
    private SnowflakeFileTransferMetadata metadata;
    private InputStream uploadStream;
    private boolean requireCompress;
    private int networkTimeoutInMilli;
    private OCSPMode ocspMode;
    private Properties proxyProperties;
    private String prefix;
    private String destFileName;
    private SFSession session;
    private String command;
    private boolean useS3RegionalUrl;
    private String streamingIngestClientName;
    private String streamingIngestClientKey;
    private boolean silentException;

    public SnowflakeFileTransferConfig(Builder builder) {
        this.metadata = builder.metadata;
        this.uploadStream = builder.uploadStream;
        this.requireCompress = builder.requireCompress;
        this.networkTimeoutInMilli = builder.networkTimeoutInMilli;
        this.ocspMode = builder.ocspMode;
        this.proxyProperties = builder.proxyProperties;
        this.prefix = builder.prefix;
        this.destFileName = builder.destFileName;
        this.session = builder.session;
        this.command = builder.command;
        this.useS3RegionalUrl = builder.useS3RegionalUrl;
        this.streamingIngestClientKey = builder.streamingIngestClientKey;
        this.streamingIngestClientName = builder.streamingIngestClientName;
        this.silentException = builder.silentException;
    }

    public SnowflakeFileTransferMetadata getSnowflakeFileTransferMetadata() {
        return this.metadata;
    }

    public InputStream getUploadStream() {
        return this.uploadStream;
    }

    public boolean getRequireCompress() {
        return this.requireCompress;
    }

    public int getNetworkTimeoutInMilli() {
        return this.networkTimeoutInMilli;
    }

    public OCSPMode getOcspMode() {
        return this.ocspMode;
    }

    public Properties getProxyProperties() {
        return this.proxyProperties;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getDestFileName() {
        return this.destFileName;
    }

    public SFSession getSession() {
        return this.session;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean getUseS3RegionalUrl() {
        return this.useS3RegionalUrl;
    }

    public String getStreamingIngestClientName() {
        return this.streamingIngestClientName;
    }

    public String getStreamingIngestClientKey() {
        return this.streamingIngestClientKey;
    }

    public boolean isSilentException() {
        return this.silentException;
    }

    public static class Builder {
        private SnowflakeFileTransferMetadata metadata = null;
        private InputStream uploadStream = null;
        private boolean requireCompress = true;
        private int networkTimeoutInMilli = 0;
        private OCSPMode ocspMode = null;
        private Properties proxyProperties = null;
        private String prefix = null;
        private String destFileName = null;
        private SFSession session = null;
        private String command = null;
        private boolean useS3RegionalUrl = false;
        private String streamingIngestClientName;
        private String streamingIngestClientKey;
        private boolean silentException = false;

        public static Builder newInstance() {
            return new Builder();
        }

        private Builder() {
        }

        public SnowflakeFileTransferConfig build() throws IllegalArgumentException {
            if (this.metadata == null) {
                throw new IllegalArgumentException("Snowflake File Transfer metadata is needed.");
            }
            if (this.uploadStream == null) {
                throw new IllegalArgumentException("Upload data stream is needed.");
            }
            if (this.ocspMode == null) {
                throw new IllegalArgumentException("Upload OCSP mode is needed.");
            }
            return new SnowflakeFileTransferConfig(this);
        }

        public Builder setSnowflakeFileTransferMetadata(SnowflakeFileTransferMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder setUploadStream(InputStream uploadStream) {
            this.uploadStream = uploadStream;
            return this;
        }

        public Builder setRequireCompress(boolean requireCompress) {
            this.requireCompress = requireCompress;
            return this;
        }

        public Builder setNetworkTimeoutInMilli(int networkTimeoutInMilli) {
            this.networkTimeoutInMilli = networkTimeoutInMilli;
            return this;
        }

        public Builder setOcspMode(OCSPMode ocspMode) {
            this.ocspMode = ocspMode;
            return this;
        }

        public Builder setProxyProperties(Properties proxyProperties) {
            this.proxyProperties = proxyProperties;
            return this;
        }

        public Builder setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder setDestFileName(String destFileName) {
            this.destFileName = destFileName;
            return this;
        }

        public Builder setSFSession(SFSession session) {
            this.session = session;
            return this;
        }

        public Builder setCommand(String command) {
            this.command = command;
            return this;
        }

        public Builder setUseS3RegionalUrl(boolean useS3RegUrl) {
            this.useS3RegionalUrl = useS3RegUrl;
            return this;
        }

        public Builder setStreamingIngestClientName(String streamingIngestClientName) {
            this.streamingIngestClientName = streamingIngestClientName;
            return this;
        }

        public Builder setStreamingIngestClientKey(String streamingIngestClientKey) {
            this.streamingIngestClientKey = streamingIngestClientKey;
            return this;
        }

        public Builder setSilentException(boolean silentException) {
            this.silentException = silentException;
            return this;
        }
    }
}

