/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.io.Serializable;
import java.util.Objects;
import net.snowflake.client.core.HttpProtocol;
import net.snowflake.client.core.OCSPMode;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.crl.CertRevocationCheckMode;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.amazonaws.Protocol;

public class HttpClientSettingsKey
implements Serializable {
    private OCSPMode ocspMode;
    private CertRevocationCheckMode revocationCheckMode;
    private boolean allowCertificatesWithoutCrlUrl;
    private boolean useProxy;
    private String proxyHost = "";
    private int proxyPort = 0;
    private String nonProxyHosts = "";
    private String proxyUser = "";
    private String proxyPassword = "";
    private String proxyProtocol = "http";
    private String userAgentSuffix = "";
    private Boolean gzipDisabled = false;

    public HttpClientSettingsKey(OCSPMode mode, String host, int port, String nonProxyHosts, String user, String password, String scheme, String userAgentSuffix, Boolean gzipDisabled) {
        this.useProxy = true;
        this.ocspMode = mode != null ? mode : OCSPMode.FAIL_OPEN;
        this.proxyHost = !SnowflakeUtil.isNullOrEmpty(host) ? host.trim() : "";
        this.proxyPort = port;
        this.nonProxyHosts = !SnowflakeUtil.isNullOrEmpty(nonProxyHosts) ? nonProxyHosts.trim() : "";
        this.proxyUser = !SnowflakeUtil.isNullOrEmpty(user) ? user.trim() : "";
        this.proxyPassword = !SnowflakeUtil.isNullOrEmpty(password) ? password.trim() : "";
        this.proxyProtocol = !SnowflakeUtil.isNullOrEmpty(scheme) ? scheme.trim() : "http";
        this.gzipDisabled = gzipDisabled;
        this.userAgentSuffix = !SnowflakeUtil.isNullOrEmpty(userAgentSuffix) ? userAgentSuffix.trim() : "";
    }

    public HttpClientSettingsKey(OCSPMode mode) {
        this.useProxy = false;
        this.ocspMode = mode != null ? mode : OCSPMode.FAIL_OPEN;
    }

    HttpClientSettingsKey(OCSPMode mode, String userAgentSuffix, Boolean gzipDisabled) {
        this(mode);
        this.userAgentSuffix = !SnowflakeUtil.isNullOrEmpty(userAgentSuffix) ? userAgentSuffix.trim() : "";
        this.gzipDisabled = gzipDisabled;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HttpClientSettingsKey) {
            HttpClientSettingsKey comparisonKey = (HttpClientSettingsKey)obj;
            if (comparisonKey.ocspMode.getValue() == this.ocspMode.getValue() && comparisonKey.revocationCheckMode == this.revocationCheckMode && comparisonKey.allowCertificatesWithoutCrlUrl == this.allowCertificatesWithoutCrlUrl && comparisonKey.gzipDisabled.equals(this.gzipDisabled) && comparisonKey.userAgentSuffix.equalsIgnoreCase(this.userAgentSuffix)) {
                if (!comparisonKey.useProxy && !this.useProxy) {
                    return true;
                }
                if (comparisonKey.proxyHost.equalsIgnoreCase(this.proxyHost) && comparisonKey.proxyPort == this.proxyPort && comparisonKey.proxyUser.equalsIgnoreCase(this.proxyUser) && comparisonKey.proxyPassword.equalsIgnoreCase(this.proxyPassword) && comparisonKey.proxyProtocol.equalsIgnoreCase(this.proxyProtocol)) {
                    if (!this.nonProxyHosts.equalsIgnoreCase(comparisonKey.nonProxyHosts)) {
                        comparisonKey.nonProxyHosts = this.nonProxyHosts;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        return this.ocspMode.getValue() + (this.proxyHost + this.proxyPort + this.proxyUser + this.proxyPassword + this.proxyProtocol).hashCode() + Objects.hash(new Object[]{this.revocationCheckMode, this.allowCertificatesWithoutCrlUrl});
    }

    public OCSPMode getOcspMode() {
        return this.ocspMode;
    }

    public boolean usesProxy() {
        return this.useProxy;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getUserAgentSuffix() {
        return this.userAgentSuffix;
    }

    @SnowflakeJdbcInternalApi
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    @Deprecated
    public Protocol getProxyProtocol() {
        return this.proxyProtocol.equalsIgnoreCase("https") ? Protocol.HTTPS : Protocol.HTTP;
    }

    public HttpProtocol getProxyHttpProtocol() {
        return this.proxyProtocol.equalsIgnoreCase("https") ? HttpProtocol.HTTPS : HttpProtocol.HTTP;
    }

    public Boolean getGzipDisabled() {
        return this.gzipDisabled;
    }

    public CertRevocationCheckMode getRevocationCheckMode() {
        return this.revocationCheckMode;
    }

    public boolean isAllowCertificatesWithoutCrlUrl() {
        return this.allowCertificatesWithoutCrlUrl;
    }

    public void setRevocationCheckMode(CertRevocationCheckMode revocationCheckMode) {
        this.revocationCheckMode = revocationCheckMode;
    }

    public void setAllowCertificatesWithoutCrlUrl(boolean allowCertificatesWithoutCrlUrl) {
        this.allowCertificatesWithoutCrlUrl = allowCertificatesWithoutCrlUrl;
    }

    public String toString() {
        return "HttpClientSettingsKey[ocspMode=" + (Object)((Object)this.ocspMode) + ", revocationCheckMode=" + (Object)((Object)this.revocationCheckMode) + ", allowCertificatesWithoutCrlUrl=" + this.allowCertificatesWithoutCrlUrl + ", useProxy=" + this.useProxy + ", proxyHost='" + this.proxyHost + '\'' + ", proxyPort=" + this.proxyPort + ", nonProxyHosts='" + this.nonProxyHosts + '\'' + ", proxyUser='" + this.proxyUser + '\'' + ", proxyPassword is " + (this.proxyPassword.isEmpty() ? "not set" : "set") + ", proxyProtocol='" + this.proxyProtocol + '\'' + ", userAgentSuffix='" + this.userAgentSuffix + '\'' + ", gzipDisabled=" + this.gzipDisabled + ']';
    }
}

