/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.ThreadSafe;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.InstrumentationScopeInfo;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.export.MemoryMode;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.AggregationTemporality;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.DoublePointData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.MetricData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.ImmutableDoublePointData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.ImmutableGaugeData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.data.MutableDoublePointData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.Measurement;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.resources.Resource;

@ThreadSafe
public final class DoubleLastValueAggregator
implements Aggregator<DoublePointData, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;
    private final MemoryMode memoryMode;

    public DoubleLastValueAggregator(Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier, MemoryMode memoryMode) {
        this.reservoirSupplier = reservoirSupplier;
        this.memoryMode = memoryMode;
    }

    @Override
    public AggregatorHandle<DoublePointData, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get(), this.memoryMode);
    }

    @Override
    public DoublePointData diff(DoublePointData previous, DoublePointData current) {
        return current;
    }

    @Override
    public void diffInPlace(DoublePointData previousReusable, DoublePointData current) {
        ((MutableDoublePointData)previousReusable).set(current);
    }

    @Override
    public DoublePointData toPoint(Measurement measurement) {
        return ImmutableDoublePointData.create(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.doubleValue());
    }

    @Override
    public void toPoint(Measurement measurement, DoublePointData reusablePoint) {
        ((MutableDoublePointData)reusablePoint).set(measurement.startEpochNanos(), measurement.epochNanos(), measurement.attributes(), measurement.doubleValue());
    }

    @Override
    public DoublePointData createReusablePoint() {
        return new MutableDoublePointData();
    }

    @Override
    public void copyPoint(DoublePointData point, DoublePointData toReusablePoint) {
        ((MutableDoublePointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<DoublePointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createDoubleGauge(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableGaugeData.create(points));
    }

    static final class Handle
    extends AggregatorHandle<DoublePointData, DoubleExemplarData> {
        @Nullable
        private static final Double DEFAULT_VALUE = null;
        private final AtomicReference<Double> current = new AtomicReference<Double>(DEFAULT_VALUE);
        @Nullable
        private final MutableDoublePointData reusablePoint;

        private Handle(ExemplarReservoir<DoubleExemplarData> reservoir, MemoryMode memoryMode) {
            super(reservoir);
            this.reusablePoint = memoryMode == MemoryMode.REUSABLE_DATA ? new MutableDoublePointData() : null;
        }

        @Override
        protected DoublePointData doAggregateThenMaybeReset(long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars, boolean reset) {
            Double value;
            Double d = value = reset ? this.current.getAndSet(DEFAULT_VALUE) : this.current.get();
            if (this.reusablePoint != null) {
                this.reusablePoint.set(startEpochNanos, epochNanos, attributes, Objects.requireNonNull(value), exemplars);
                return this.reusablePoint;
            }
            return ImmutableDoublePointData.create(startEpochNanos, epochNanos, attributes, Objects.requireNonNull(value), exemplars);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.set(value);
        }
    }
}

