/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.ResultUtil;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.arrow.AbstractArrowVectorConverter;
import net.snowflake.client.core.arrow.ArrowResultUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeTimeWithTimezone;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.BigIntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.IntVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.StructVector;

public class TwoFieldStructToTimestampNTZConverter
extends AbstractArrowVectorConverter {
    private StructVector structVector;
    private BigIntVector epochs;
    private IntVector fractions;
    private static final TimeZone NTZ = TimeZone.getTimeZone("UTC");

    public TwoFieldStructToTimestampNTZConverter(ValueVector fieldVector, int columnIndex, DataConversionContext context) {
        super(SnowflakeType.TIMESTAMP_NTZ.name(), fieldVector, columnIndex, context);
        this.structVector = (StructVector)fieldVector;
        this.epochs = this.structVector.getChild("epoch", BigIntVector.class);
        this.fractions = this.structVector.getChild("fraction", IntVector.class);
    }

    @Override
    public boolean isNull(int index) {
        return this.structVector.isNull(index) || this.epochs.isNull(index) || this.fractions.isNull(index);
    }

    @Override
    public String toString(int index) throws SFException {
        if (this.context.getTimestampNTZFormatter() == null) {
            throw new SFException(ErrorCode.INTERNAL_ERROR, "missing timestamp NTZ formatter");
        }
        try {
            Timestamp ts = this.isNull(index) ? null : this.getTimestamp(index, TimeZone.getDefault(), true);
            return ts == null ? null : this.context.getTimestampNTZFormatter().format(ts, TimeZone.getTimeZone("UTC"), this.context.getScale(this.columnIndex));
        }
        catch (AbstractArrowVectorConverter.TimestampOperationNotAvailableException e) {
            return e.getSecsSinceEpoch().toPlainString();
        }
    }

    @Override
    public Object toObject(int index) throws SFException {
        return this.toTimestamp(index, TimeZone.getDefault());
    }

    @Override
    public Timestamp toTimestamp(int index, TimeZone tz) throws SFException {
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        return this.isNull(index) ? null : this.getTimestamp(index, tz, false);
    }

    private Timestamp getTimestamp(int index, TimeZone tz, boolean fromToString) throws SFException {
        long epoch = this.epochs.getDataBuffer().getLong(index * 8);
        int fraction = this.fractions.getDataBuffer().getInt(index * 4);
        return TwoFieldStructToTimestampNTZConverter.getTimestamp(epoch, fraction, tz, this.sessionTimeZone, this.treatNTZasUTC, this.useSessionTimezone, this.context.getHonorClientTZForTimestampNTZ(), fromToString);
    }

    @Override
    public byte[] toBytes(int index) throws SFException {
        if (this.isNull(index)) {
            return null;
        }
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "byteArray", this.toString(index));
    }

    @Override
    public Date toDate(int index, TimeZone tz, boolean dateFormat) throws SFException {
        return this.isNull(index) ? null : new Date(this.getTimestamp(index, TimeZone.getDefault(), false).getTime());
    }

    @Override
    public Time toTime(int index) throws SFException {
        Timestamp ts = this.toTimestamp(index, null);
        if (this.useSessionTimezone) {
            ts = this.toTimestamp(index, this.sessionTimeZone);
        }
        return ts == null ? null : new SnowflakeTimeWithTimezone(ts, this.sessionTimeZone, this.useSessionTimezone);
    }

    @Override
    public boolean toBoolean(int index) throws SFException {
        if (this.isNull(index)) {
            return false;
        }
        Timestamp val = this.toTimestamp(index, TimeZone.getDefault());
        throw new SFException(ErrorCode.INVALID_VALUE_CONVERT, this.logicalTypeStr, "boolean", val);
    }

    public static Timestamp getTimestamp(long epoch, int fraction, TimeZone tz, TimeZone sessionTimeZone, boolean treatNTZasUTC, boolean useSessionTimezone, boolean honorClientTZForTimestampNTZ, boolean fromToString) throws SFException {
        if (ArrowResultUtil.isTimestampOverflow(epoch)) {
            if (fromToString) {
                throw new AbstractArrowVectorConverter.TimestampOperationNotAvailableException(epoch, fraction);
            }
            return null;
        }
        Timestamp ts = treatNTZasUTC || !useSessionTimezone ? ArrowResultUtil.createTimestamp(epoch, fraction, TimeZone.getTimeZone("UTC"), true) : ArrowResultUtil.createTimestamp(epoch, fraction, sessionTimeZone, false);
        if (!fromToString && honorClientTZForTimestampNTZ && !treatNTZasUTC || useSessionTimezone) {
            ts = ArrowResultUtil.moveToTimeZone(ts, NTZ, tz);
        }
        return ResultUtil.adjustTimestamp(ts);
    }
}

