/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.Clock;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.InstrumentationScopeInfo;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.ScopeConfigurator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.internal.ScopeConfiguratorBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.resources.Resource;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.IdGenerator;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.SdkTracerProvider;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.SpanLimits;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.SpanProcessor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.internal.TracerConfig;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.trace.samplers.Sampler;

public final class SdkTracerProviderBuilder {
    private static final Sampler DEFAULT_SAMPLER = Sampler.parentBased(Sampler.alwaysOn());
    private final List<SpanProcessor> spanProcessors = new ArrayList<SpanProcessor>();
    private Clock clock = Clock.getDefault();
    private IdGenerator idsGenerator = IdGenerator.random();
    private Resource resource = Resource.getDefault();
    private Supplier<SpanLimits> spanLimitsSupplier = SpanLimits::getDefault;
    private Sampler sampler = DEFAULT_SAMPLER;
    private ScopeConfiguratorBuilder<TracerConfig> tracerConfiguratorBuilder = TracerConfig.configuratorBuilder();

    public SdkTracerProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkTracerProviderBuilder setIdGenerator(IdGenerator idGenerator) {
        Objects.requireNonNull(idGenerator, "idGenerator");
        this.idsGenerator = idGenerator;
        return this;
    }

    public SdkTracerProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkTracerProviderBuilder addResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = this.resource.merge(resource);
        return this;
    }

    public SdkTracerProviderBuilder setSpanLimits(SpanLimits spanLimits) {
        Objects.requireNonNull(spanLimits, "spanLimits");
        this.spanLimitsSupplier = () -> spanLimits;
        return this;
    }

    public SdkTracerProviderBuilder setSpanLimits(Supplier<SpanLimits> spanLimitsSupplier) {
        Objects.requireNonNull(spanLimitsSupplier, "spanLimitsSupplier");
        this.spanLimitsSupplier = spanLimitsSupplier;
        return this;
    }

    public SdkTracerProviderBuilder setSampler(Sampler sampler) {
        Objects.requireNonNull(sampler, "sampler");
        this.sampler = sampler;
        return this;
    }

    public SdkTracerProviderBuilder addSpanProcessor(SpanProcessor spanProcessor) {
        this.spanProcessors.add(spanProcessor);
        return this;
    }

    SdkTracerProviderBuilder setTracerConfigurator(ScopeConfigurator<TracerConfig> tracerConfigurator) {
        this.tracerConfiguratorBuilder = tracerConfigurator.toBuilder();
        return this;
    }

    SdkTracerProviderBuilder addTracerConfiguratorCondition(Predicate<InstrumentationScopeInfo> scopeMatcher, TracerConfig tracerConfig) {
        this.tracerConfiguratorBuilder.addCondition(scopeMatcher, tracerConfig);
        return this;
    }

    public SdkTracerProvider build() {
        return new SdkTracerProvider(this.clock, this.idsGenerator, this.resource, this.spanLimitsSupplier, this.sampler, this.spanProcessors, this.tracerConfiguratorBuilder.build());
    }

    SdkTracerProviderBuilder() {
    }
}

