/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.common.Clock;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.ExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.data.LongExemplarData;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.FilteredExemplarReservoir;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.HistogramExemplarReservoir;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.LongToDoubleExemplarReservoir;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.NoopExemplarReservoir;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.exemplar.RandomFixedSizeExemplarReservoir;

public interface ExemplarReservoir<T extends ExemplarData> {
    public static <T extends ExemplarData> ExemplarReservoir<T> longToDouble(ExemplarReservoir<T> delegate) {
        return new LongToDoubleExemplarReservoir<T>(delegate);
    }

    public static <T extends ExemplarData> ExemplarReservoir<T> filtered(ExemplarFilter filter, ExemplarReservoir<T> original) {
        return new FilteredExemplarReservoir<T>(filter, original);
    }

    public static ExemplarReservoir<DoubleExemplarData> doubleNoSamples() {
        return NoopExemplarReservoir.DOUBLE_INSTANCE;
    }

    public static ExemplarReservoir<LongExemplarData> longNoSamples() {
        return NoopExemplarReservoir.LONG_INSTANCE;
    }

    public static ExemplarReservoir<DoubleExemplarData> doubleFixedSizeReservoir(Clock clock, int size, Supplier<Random> randomSupplier) {
        return RandomFixedSizeExemplarReservoir.createDouble(clock, size, randomSupplier);
    }

    public static ExemplarReservoir<LongExemplarData> longFixedSizeReservoir(Clock clock, int size, Supplier<Random> randomSupplier) {
        return RandomFixedSizeExemplarReservoir.createLong(clock, size, randomSupplier);
    }

    public static ExemplarReservoir<DoubleExemplarData> histogramBucketReservoir(Clock clock, List<Double> boundaries) {
        return new HistogramExemplarReservoir(clock, boundaries);
    }

    public void offerDoubleMeasurement(double var1, Attributes var3, Context var4);

    public void offerLongMeasurement(long var1, Attributes var3, Context var4);

    public List<T> collectAndReset(Attributes var1);
}

