/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics;

import java.util.List;
import java.util.function.Consumer;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.AttributeKey;
import net.snowflake.client.jdbc.internal.opentelemetry.api.common.Attributes;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.metrics.ExtendedDoubleUpDownCounter;
import net.snowflake.client.jdbc.internal.opentelemetry.api.incubator.metrics.ExtendedDoubleUpDownCounterBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.DoubleUpDownCounter;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.ObservableDoubleMeasurement;
import net.snowflake.client.jdbc.internal.opentelemetry.api.metrics.ObservableDoubleUpDownCounter;
import net.snowflake.client.jdbc.internal.opentelemetry.context.Context;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.AbstractInstrument;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentBuilder;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentType;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.InstrumentValueType;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.descriptor.Advice;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import net.snowflake.client.jdbc.internal.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

final class SdkDoubleUpDownCounter
extends AbstractInstrument
implements ExtendedDoubleUpDownCounter {
    private final MeterSharedState meterSharedState;
    private final WriteableMetricStorage storage;

    private SdkDoubleUpDownCounter(InstrumentDescriptor descriptor, MeterSharedState meterSharedState, WriteableMetricStorage storage) {
        super(descriptor);
        this.meterSharedState = meterSharedState;
        this.storage = storage;
    }

    @Override
    public void add(double increment, Attributes attributes, Context context) {
        this.storage.recordDouble(increment, attributes, context);
    }

    @Override
    public void add(double increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    @Override
    public void add(double increment) {
        this.add(increment, Attributes.empty());
    }

    @Override
    public boolean isEnabled() {
        return this.meterSharedState.isMeterEnabled() && this.storage.isEnabled();
    }

    static final class SdkDoubleUpDownCounterBuilder
    implements ExtendedDoubleUpDownCounterBuilder {
        private final InstrumentBuilder builder;

        SdkDoubleUpDownCounterBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit, Advice.AdviceBuilder adviceBuilder) {
            this.builder = new InstrumentBuilder(name, InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.DOUBLE, meterProviderSharedState, sharedState).setDescription(description).setUnit(unit).setAdviceBuilder(adviceBuilder);
        }

        @Override
        public DoubleUpDownCounterBuilder setDescription(String description) {
            this.builder.setDescription(description);
            return this;
        }

        @Override
        public DoubleUpDownCounterBuilder setUnit(String unit) {
            this.builder.setUnit(unit);
            return this;
        }

        @Override
        public DoubleUpDownCounter build() {
            return this.builder.buildSynchronousInstrument((x$0, x$1, x$2) -> new SdkDoubleUpDownCounter(x$0, x$1, x$2));
        }

        @Override
        public ObservableDoubleUpDownCounter buildWithCallback(Consumer<ObservableDoubleMeasurement> callback) {
            return this.builder.buildDoubleAsynchronousInstrument(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, callback);
        }

        @Override
        public ObservableDoubleMeasurement buildObserver() {
            return this.builder.buildObservableMeasurement(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER);
        }

        @Override
        public ExtendedDoubleUpDownCounterBuilder setAttributesAdvice(List<AttributeKey<?>> attributes) {
            this.builder.setAdviceAttributes(attributes);
            return this;
        }

        public String toString() {
            return this.builder.toStringHelper(this.getClass().getSimpleName());
        }
    }
}

