/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.microsoft.azure.storage;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.SharedAccessPolicy;
import net.snowflake.client.jdbc.internal.microsoft.azure.storage.core.Utility;

public final class SharedAccessPolicySerializer {
    public static <T extends SharedAccessPolicy> void writeSharedAccessIdentifiersToStream(HashMap<String, T> sharedAccessPolicies, StringWriter outWriter) throws XMLStreamException {
        Utility.assertNotNull("sharedAccessPolicies", sharedAccessPolicies);
        Utility.assertNotNull("outWriter", outWriter);
        XMLStreamWriter xmlw = Utility.createXMLStreamWriter(outWriter);
        if (sharedAccessPolicies.keySet().size() > 5) {
            String errorMessage = String.format("Too many %d shared access policy identifiers provided. Server does not support setting more than %d on a single container, queue, or table.", sharedAccessPolicies.keySet().size(), 5);
            throw new IllegalArgumentException(errorMessage);
        }
        xmlw.writeStartDocument();
        xmlw.writeStartElement("SignedIdentifiers");
        for (Map.Entry<String, T> entry : sharedAccessPolicies.entrySet()) {
            SharedAccessPolicy policy = (SharedAccessPolicy)entry.getValue();
            xmlw.writeStartElement("SignedIdentifier");
            xmlw.writeStartElement("Id");
            xmlw.writeCharacters(entry.getKey());
            xmlw.writeEndElement();
            xmlw.writeStartElement("AccessPolicy");
            xmlw.writeStartElement("Start");
            xmlw.writeCharacters(Utility.getUTCTimeOrEmpty(policy.getSharedAccessStartTime()));
            xmlw.writeEndElement();
            xmlw.writeStartElement("Expiry");
            xmlw.writeCharacters(Utility.getUTCTimeOrEmpty(policy.getSharedAccessExpiryTime()));
            xmlw.writeEndElement();
            xmlw.writeStartElement("Permission");
            xmlw.writeCharacters(policy.permissionsToString());
            xmlw.writeEndElement();
            xmlw.writeEndElement();
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
        xmlw.writeEndDocument();
    }
}

