/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.grpc.xds;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.grpc.internal.ExponentialBackoffPolicy;
import net.snowflake.client.jdbc.internal.grpc.internal.GrpcUtil;
import net.snowflake.client.jdbc.internal.grpc.internal.ObjectPool;
import net.snowflake.client.jdbc.internal.grpc.internal.SharedResourceHolder;
import net.snowflake.client.jdbc.internal.grpc.internal.TimeProvider;
import net.snowflake.client.jdbc.internal.grpc.xds.GrpcBootstrapperImpl;
import net.snowflake.client.jdbc.internal.grpc.xds.GrpcXdsTransportFactory;
import net.snowflake.client.jdbc.internal.grpc.xds.MessagePrinter;
import net.snowflake.client.jdbc.internal.grpc.xds.XdsClientPoolFactory;
import net.snowflake.client.jdbc.internal.grpc.xds.client.Bootstrapper;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsClient;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsClientImpl;
import net.snowflake.client.jdbc.internal.grpc.xds.client.XdsInitializationException;
import net.snowflake.client.jdbc.internal.grpc.xds.internal.security.TlsContextManagerImpl;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.GuardedBy;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class SharedXdsClientPoolProvider
implements XdsClientPoolFactory {
    private static final boolean LOG_XDS_NODE_ID = Boolean.parseBoolean(System.getenv("GRPC_LOG_XDS_NODE_ID"));
    private static final Logger log = Logger.getLogger(XdsClientImpl.class.getName());
    private final Bootstrapper bootstrapper;
    private final Object lock = new Object();
    private final AtomicReference<Map<String, ?>> bootstrapOverride = new AtomicReference();
    private final Map<String, ObjectPool<XdsClient>> targetToXdsClientMap = new ConcurrentHashMap<String, ObjectPool<XdsClient>>();

    SharedXdsClientPoolProvider() {
        this(new GrpcBootstrapperImpl());
    }

    @VisibleForTesting
    SharedXdsClientPoolProvider(Bootstrapper bootstrapper) {
        this.bootstrapper = Preconditions.checkNotNull(bootstrapper, "bootstrapper");
    }

    static SharedXdsClientPoolProvider getDefaultProvider() {
        return SharedXdsClientPoolProviderHolder.instance;
    }

    @Override
    public void setBootstrapOverride(Map<String, ?> bootstrap) {
        this.bootstrapOverride.set(bootstrap);
    }

    @Override
    @Nullable
    public ObjectPool<XdsClient> get(String target) {
        return this.targetToXdsClientMap.get(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectPool<XdsClient> getOrCreate(String target) throws XdsInitializationException {
        RefCountedXdsClientObjectPool ref = this.targetToXdsClientMap.get(target);
        if (ref == null) {
            Object object = this.lock;
            synchronized (object) {
                ref = this.targetToXdsClientMap.get(target);
                if (ref == null) {
                    Map<String, ?> rawBootstrap = this.bootstrapOverride.get();
                    Bootstrapper.BootstrapInfo bootstrapInfo = rawBootstrap != null ? this.bootstrapper.bootstrap(rawBootstrap) : this.bootstrapper.bootstrap();
                    if (bootstrapInfo.servers().isEmpty()) {
                        throw new XdsInitializationException("No xDS server provided");
                    }
                    ref = new RefCountedXdsClientObjectPool(bootstrapInfo, target);
                    this.targetToXdsClientMap.put(target, ref);
                }
            }
        }
        return ref;
    }

    public ImmutableList<String> getTargets() {
        return ImmutableList.copyOf(this.targetToXdsClientMap.keySet());
    }

    @ThreadSafe
    @VisibleForTesting
    static class RefCountedXdsClientObjectPool
    implements ObjectPool<XdsClient> {
        private static final ExponentialBackoffPolicy.Provider BACKOFF_POLICY_PROVIDER = new ExponentialBackoffPolicy.Provider();
        private final Bootstrapper.BootstrapInfo bootstrapInfo;
        private final String target;
        private final Object lock = new Object();
        @GuardedBy(value="lock")
        private ScheduledExecutorService scheduler;
        @GuardedBy(value="lock")
        private XdsClient xdsClient;
        @GuardedBy(value="lock")
        private int refCount;

        @VisibleForTesting
        RefCountedXdsClientObjectPool(Bootstrapper.BootstrapInfo bootstrapInfo, String target) {
            this.bootstrapInfo = Preconditions.checkNotNull(bootstrapInfo);
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XdsClient getObject() {
            Object object = this.lock;
            synchronized (object) {
                if (this.refCount == 0) {
                    if (LOG_XDS_NODE_ID) {
                        log.log(Level.INFO, "xDS node ID: {0}", this.bootstrapInfo.node().getId());
                    }
                    this.scheduler = SharedResourceHolder.get(GrpcUtil.TIMER_SERVICE);
                    this.xdsClient = new XdsClientImpl(GrpcXdsTransportFactory.DEFAULT_XDS_TRANSPORT_FACTORY, this.bootstrapInfo, this.scheduler, BACKOFF_POLICY_PROVIDER, GrpcUtil.STOPWATCH_SUPPLIER, TimeProvider.SYSTEM_TIME_PROVIDER, MessagePrinter.INSTANCE, new TlsContextManagerImpl(this.bootstrapInfo));
                }
                ++this.refCount;
                return this.xdsClient;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public XdsClient returnObject(Object object) {
            Object object2 = this.lock;
            synchronized (object2) {
                --this.refCount;
                if (this.refCount == 0) {
                    this.xdsClient.shutdown();
                    this.xdsClient = null;
                    this.scheduler = SharedResourceHolder.release(GrpcUtil.TIMER_SERVICE, this.scheduler);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        @VisibleForTesting
        XdsClient getXdsClientForTest() {
            Object object = this.lock;
            synchronized (object) {
                return this.xdsClient;
            }
        }

        public String getTarget() {
            return this.target;
        }
    }

    private static class SharedXdsClientPoolProviderHolder {
        private static final SharedXdsClientPoolProvider instance = new SharedXdsClientPoolProvider();

        private SharedXdsClientPoolProviderHolder() {
        }
    }
}

