/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.flatbuffers;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import net.snowflake.client.jdbc.internal.google.flatbuffers.Utf8;

public class Utf8Old
extends Utf8 {
    private static final ThreadLocal<Cache> CACHE = new ThreadLocal<Cache>(){

        @Override
        protected Cache initialValue() {
            return new Cache();
        }
    };

    @Override
    public int encodedLength(CharSequence in) {
        Cache cache = CACHE.get();
        int estimated = (int)((float)in.length() * cache.encoder.maxBytesPerChar());
        if (cache.lastOutput == null || cache.lastOutput.capacity() < estimated) {
            cache.lastOutput = ByteBuffer.allocate(Math.max(128, estimated));
        }
        cache.lastOutput.clear();
        cache.lastInput = in;
        CharBuffer wrap = in instanceof CharBuffer ? (CharBuffer)in : CharBuffer.wrap(in);
        CoderResult result = cache.encoder.encode(wrap, cache.lastOutput, true);
        if (result.isError()) {
            try {
                result.throwException();
            }
            catch (CharacterCodingException e) {
                throw new IllegalArgumentException("bad character encoding", e);
            }
        }
        cache.lastOutput.flip();
        return cache.lastOutput.remaining();
    }

    @Override
    public void encodeUtf8(CharSequence in, ByteBuffer out) {
        Cache cache = CACHE.get();
        if (cache.lastInput != in) {
            this.encodedLength(in);
        }
        out.put(cache.lastOutput);
    }

    @Override
    public String decodeUtf8(ByteBuffer buffer, int offset, int length) {
        CharsetDecoder decoder = Utf8Old.CACHE.get().decoder;
        decoder.reset();
        buffer = buffer.duplicate();
        buffer.position(offset);
        buffer.limit(offset + length);
        try {
            CharBuffer result = decoder.decode(buffer);
            return result.toString();
        }
        catch (CharacterCodingException e) {
            throw new IllegalArgumentException("Bad encoding", e);
        }
    }

    private static class Cache {
        final CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        CharSequence lastInput = null;
        ByteBuffer lastOutput = null;

        Cache() {
        }
    }
}

