/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage.transfermanager;

import java.util.List;
import java.util.Objects;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Storage;
import net.snowflake.client.jdbc.internal.google.common.base.MoreObjects;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.NonNull;

public final class ParallelUploadConfig {
    private final boolean skipIfExists;
    private final @NonNull String prefix;
    private final @NonNull String bucketName;
    private final @NonNull List<Storage.BlobWriteOption> writeOptsPerRequest;

    private ParallelUploadConfig(boolean skipIfExists, @NonNull String prefix, @NonNull String bucketName, @NonNull List<Storage.BlobWriteOption> writeOptsPerRequest) {
        this.skipIfExists = skipIfExists;
        this.prefix = prefix;
        this.bucketName = bucketName;
        this.writeOptsPerRequest = ParallelUploadConfig.applySkipIfExists(skipIfExists, writeOptsPerRequest);
    }

    public boolean isSkipIfExists() {
        return this.skipIfExists;
    }

    public @NonNull String getPrefix() {
        return this.prefix;
    }

    public @NonNull String getBucketName() {
        return this.bucketName;
    }

    public @NonNull List<Storage.BlobWriteOption> getWriteOptsPerRequest() {
        return this.writeOptsPerRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParallelUploadConfig that = (ParallelUploadConfig)o;
        return this.skipIfExists == that.skipIfExists && this.prefix.equals(that.prefix) && this.bucketName.equals(that.bucketName) && this.writeOptsPerRequest.equals(that.writeOptsPerRequest);
    }

    public int hashCode() {
        return Objects.hash(this.skipIfExists, this.prefix, this.bucketName, this.writeOptsPerRequest);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("skipIfExists", this.skipIfExists).add("prefix", this.prefix).add("bucketName", this.bucketName).add("writeOptsPerRequest", this.writeOptsPerRequest).toString();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static List<Storage.BlobWriteOption> applySkipIfExists(boolean skipIfExists, List<Storage.BlobWriteOption> writeOptsPerRequest) {
        if (skipIfExists) {
            return ImmutableList.copyOf(Storage.BlobWriteOption.dedupe(writeOptsPerRequest, Storage.BlobWriteOption.doesNotExist()));
        }
        return writeOptsPerRequest;
    }

    public static final class Builder {
        private boolean skipIfExists;
        private @NonNull String prefix = "";
        private @NonNull String bucketName = "";
        private @NonNull List<Storage.BlobWriteOption> writeOptsPerRequest = ImmutableList.of();

        private Builder() {
        }

        public Builder setSkipIfExists(boolean skipIfExists) {
            this.skipIfExists = skipIfExists;
            return this;
        }

        public Builder setPrefix(@NonNull String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder setBucketName(@NonNull String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public Builder setWriteOptsPerRequest(@NonNull List<Storage.BlobWriteOption> writeOptsPerRequest) {
            this.writeOptsPerRequest = writeOptsPerRequest;
            return this;
        }

        public ParallelUploadConfig build() {
            Preconditions.checkNotNull(this.prefix);
            Preconditions.checkNotNull(this.bucketName);
            Preconditions.checkNotNull(this.writeOptsPerRequest);
            return new ParallelUploadConfig(this.skipIfExists, this.prefix, this.bucketName, this.writeOptsPerRequest);
        }
    }
}

