/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.auth.oauth2;

import java.io.IOException;
import java.util.Map;
import net.snowflake.client.jdbc.internal.google.api.client.http.GenericUrl;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpHeaders;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpRequest;
import net.snowflake.client.jdbc.internal.google.api.client.http.HttpResponse;
import net.snowflake.client.jdbc.internal.google.api.client.json.JsonObjectParser;
import net.snowflake.client.jdbc.internal.google.auth.http.HttpTransportFactory;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.ExternalAccountSupplierContext;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.FileIdentityPoolSubjectTokenSupplier;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.IdentityPoolCredentialSource;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.IdentityPoolSubjectTokenSupplier;
import net.snowflake.client.jdbc.internal.google.auth.oauth2.OAuth2Utils;

class UrlIdentityPoolSubjectTokenSupplier
implements IdentityPoolSubjectTokenSupplier {
    private static final long serialVersionUID = 4964578313468011844L;
    private final IdentityPoolCredentialSource credentialSource;
    private final transient HttpTransportFactory transportFactory;

    UrlIdentityPoolSubjectTokenSupplier(IdentityPoolCredentialSource credentialSource, HttpTransportFactory transportFactory) {
        this.credentialSource = credentialSource;
        this.transportFactory = transportFactory;
    }

    @Override
    public String getSubjectToken(ExternalAccountSupplierContext context) throws IOException {
        HttpRequest request = this.transportFactory.create().createRequestFactory().buildGetRequest(new GenericUrl(this.credentialSource.credentialLocation));
        request.setParser(new JsonObjectParser(OAuth2Utils.JSON_FACTORY));
        if (this.credentialSource.hasHeaders()) {
            HttpHeaders headers = new HttpHeaders();
            headers.putAll((Map<? extends String, ?>)this.credentialSource.headers);
            request.setHeaders(headers);
        }
        try {
            HttpResponse response = request.execute();
            return FileIdentityPoolSubjectTokenSupplier.parseToken(response.getContent(), this.credentialSource);
        }
        catch (IOException e) {
            throw new IOException(String.format("Error getting subject token from metadata server: %s", e.getMessage()), e);
        }
    }
}

