/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.time.Duration;
import java.util.Map;

public class SFLoginOutput {
    private String sessionToken;
    private String masterToken;
    private long masterTokenValidityInSeconds;
    private String idToken;
    private String mfaToken;
    private String databaseVersion;
    private int databaseMajorVersion;
    private int databaseMinorVersion;
    private Duration httpClientSocketTimeout;
    private Duration httpClientConnectionTimeout;
    private String sessionDatabase;
    private String sessionSchema;
    private String sessionRole;
    private String sessionWarehouse;
    private Map<String, Object> commonParams;
    private String sessionId;

    SFLoginOutput() {
    }

    SFLoginOutput(String sessionToken, String masterToken, long masterTokenValidityInSeconds, String idToken, String mfaToken, String databaseVersion, int databaseMajorVersion, int databaseMinorVersion, int httpClientSocketTimeout, int httpClientConnectionTimeout, String sessionDatabase, String sessionSchema, String sessionRole, String sessionWarehouse, String sessionId, Map<String, Object> commonParams) {
        this.sessionToken = sessionToken;
        this.masterToken = masterToken;
        this.idToken = idToken;
        this.mfaToken = mfaToken;
        this.databaseVersion = databaseVersion;
        this.databaseMajorVersion = databaseMajorVersion;
        this.databaseMinorVersion = databaseMinorVersion;
        this.httpClientSocketTimeout = Duration.ofMillis(httpClientSocketTimeout);
        this.httpClientConnectionTimeout = Duration.ofMillis(httpClientConnectionTimeout);
        this.sessionDatabase = sessionDatabase;
        this.sessionSchema = sessionSchema;
        this.sessionRole = sessionRole;
        this.sessionWarehouse = sessionWarehouse;
        this.commonParams = commonParams;
        this.masterTokenValidityInSeconds = masterTokenValidityInSeconds;
        this.sessionId = sessionId;
    }

    public boolean getAutoCommit() {
        return (Boolean)this.commonParams.get("AUTOCOMMIT");
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public SFLoginOutput setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
        return this;
    }

    String getMasterToken() {
        return this.masterToken;
    }

    SFLoginOutput setMasterToken(String masterToken) {
        this.masterToken = masterToken;
        return this;
    }

    String getIdToken() {
        return this.idToken;
    }

    String getMfaToken() {
        return this.mfaToken;
    }

    String getDatabaseVersion() {
        return this.databaseVersion;
    }

    int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    Duration getHttpClientSocketTimeout() {
        return this.httpClientSocketTimeout;
    }

    Duration getHttpClientConnectionTimeout() {
        return this.httpClientConnectionTimeout;
    }

    Map<String, Object> getCommonParams() {
        return this.commonParams;
    }

    String getSessionDatabase() {
        return this.sessionDatabase;
    }

    String getSessionSchema() {
        return this.sessionSchema;
    }

    String getSessionRole() {
        return this.sessionRole;
    }

    String getSessionWarehouse() {
        return this.sessionWarehouse;
    }

    long getMasterTokenValidityInSeconds() {
        return this.masterTokenValidityInSeconds;
    }
}

