/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.snowflake.client.core.ColumnTypeHelper;
import net.snowflake.client.core.JsonSqlInput;
import net.snowflake.client.core.MetaDataOfBinds;
import net.snowflake.client.core.ObjectMapperFactory;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFResultSetMetaData;
import net.snowflake.client.core.SFStatementType;
import net.snowflake.client.core.SfSqlArray;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.json.Converters;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.FieldMetadata;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializable;
import net.snowflake.client.jdbc.SnowflakeResultSetSerializableV1;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeUtil;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.node.ArrayNode;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SFBinaryFormat;
import net.snowflake.client.jdbc.internal.snowflake.common.core.SnowflakeDateTimeFormat;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;
import net.snowflake.client.util.Converter;

public abstract class SFBaseResultSet {
    private static final SFLogger logger = SFLoggerFactory.getLogger(SFBaseResultSet.class);
    protected static final ObjectMapper OBJECT_MAPPER = ObjectMapperFactory.getObjectMapper();
    boolean wasNull = false;
    protected SFResultSetMetaData resultSetMetaData = null;
    protected int row = 0;
    protected Map<String, Object> parameters = new HashMap<String, Object>();
    SnowflakeDateTimeFormat timestampNTZFormatter;
    SnowflakeDateTimeFormat timestampLTZFormatter;
    SnowflakeDateTimeFormat timestampTZFormatter;
    SnowflakeDateTimeFormat dateFormatter;
    SnowflakeDateTimeFormat timeFormatter;
    boolean honorClientTZForTimestampNTZ = true;
    SFBinaryFormat binaryFormatter;
    protected long resultVersion = 0L;
    protected int numberOfBinds = 0;
    protected List<MetaDataOfBinds> metaDataOfBinds = new ArrayList<MetaDataOfBinds>();
    protected SFBaseSession session;
    protected boolean isClosed;
    protected SnowflakeResultSetSerializableV1 resultSetSerializable;
    protected TimeZone sessionTimeZone;

    public abstract boolean isLast();

    public abstract boolean isAfterLast();

    public abstract String getString(int var1) throws SFException;

    public abstract boolean getBoolean(int var1) throws SFException;

    public abstract byte getByte(int var1) throws SFException;

    public abstract short getShort(int var1) throws SFException;

    public abstract int getInt(int var1) throws SFException;

    public abstract long getLong(int var1) throws SFException;

    public abstract float getFloat(int var1) throws SFException;

    public abstract double getDouble(int var1) throws SFException;

    public abstract byte[] getBytes(int var1) throws SFException;

    public abstract Time getTime(int var1) throws SFException;

    public abstract Timestamp getTimestamp(int var1, TimeZone var2) throws SFException;

    public abstract Date getDate(int var1, TimeZone var2) throws SFException;

    public abstract Object getObject(int var1) throws SFException;

    @SnowflakeJdbcInternalApi
    public abstract Object getObjectWithoutString(int var1) throws SFException;

    public java.sql.Array getArray(int columnIndex) throws SFException {
        throw new UnsupportedOperationException();
    }

    public abstract BigDecimal getBigDecimal(int var1) throws SFException;

    public abstract BigDecimal getBigDecimal(int var1, int var2) throws SFException;

    public abstract SFStatementType getStatementType();

    public abstract void setStatementType(SFStatementType var1) throws SQLException;

    public abstract String getQueryId();

    public void setSession(SFBaseSession session) {
        this.session = session;
    }

    public SFBaseSession getSession() {
        return this.session;
    }

    public boolean next() throws SFException, SnowflakeSQLException {
        logger.trace("boolean next()", false);
        return false;
    }

    public void close() throws SnowflakeSQLException {
        logger.trace("void close()", false);
        this.resultSetMetaData = null;
        this.isClosed = true;
    }

    public boolean wasNull() {
        logger.trace("boolean wasNull() returning {}", this.wasNull);
        return this.wasNull;
    }

    public SFResultSetMetaData getMetaData() {
        return this.resultSetMetaData;
    }

    public TimeZone getSessionTimezone() {
        return this.sessionTimeZone;
    }

    public int getRow() throws SQLException {
        return this.row;
    }

    public boolean absolute(int row) throws SFException {
        throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "seek to a specific row");
    }

    public boolean relative(int rows) throws SFException {
        throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "seek to a row relative to current row");
    }

    public boolean previous() throws SFException {
        throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "seek to a previous row");
    }

    public int getNumberOfBinds() {
        return this.numberOfBinds;
    }

    public List<MetaDataOfBinds> getMetaDataOfBinds() {
        return this.metaDataOfBinds;
    }

    public boolean isFirst() {
        return this.row == 1;
    }

    public boolean isBeforeFirst() {
        return this.row == 0;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isArrayBindSupported() {
        return false;
    }

    public List<SnowflakeResultSetSerializable> getResultSetSerializables(long maxSizeInBytes) throws SQLException {
        return this.resultSetSerializable.splitBySize(maxSizeInBytes);
    }

    @SnowflakeJdbcInternalApi
    public Converters getConverters() {
        logger.debug("Json converters weren't created", new Object[0]);
        return null;
    }

    @SnowflakeJdbcInternalApi
    public TimeZone getSessionTimeZone() {
        return this.resultSetSerializable.getTimeZone();
    }

    @SnowflakeJdbcInternalApi
    public SQLInput createSqlInputForColumn(Object input, Class<?> parentObjectClass, int columnIndex, SFBaseSession session, List<FieldMetadata> fields) {
        throw new UnsupportedOperationException();
    }

    @SnowflakeJdbcInternalApi
    public Date convertToDate(Object object, TimeZone tz) throws SFException {
        throw new UnsupportedOperationException();
    }

    @SnowflakeJdbcInternalApi
    public Time convertToTime(Object object, int scale) throws SFException {
        throw new UnsupportedOperationException();
    }

    @SnowflakeJdbcInternalApi
    public Timestamp convertToTimestamp(Object object, int columnType, int columnSubType, TimeZone tz, int scale) throws SFException {
        throw new UnsupportedOperationException();
    }

    @SnowflakeJdbcInternalApi
    protected SQLInput createJsonSqlInputForColumn(Object input, SFBaseSession session, List<FieldMetadata> fields) {
        JsonNode inputNode = input instanceof JsonNode ? (JsonNode)input : OBJECT_MAPPER.convertValue(input, JsonNode.class);
        return new JsonSqlInput(input.toString(), inputNode, session, this.getConverters(), fields, this.sessionTimeZone);
    }

    @SnowflakeJdbcInternalApi
    protected SfSqlArray getJsonArray(String arrayString, int columnIndex) throws SFException {
        try {
            List<FieldMetadata> fieldMetadataList = this.resultSetMetaData.getColumnFields(columnIndex);
            if (fieldMetadataList.size() != 1) {
                throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "Wrong size of fields for array type " + fieldMetadataList.size());
            }
            FieldMetadata fieldMetadata = fieldMetadataList.get(0);
            int columnSubType = fieldMetadata.getType();
            int columnType = ColumnTypeHelper.getColumnType(columnSubType, this.session);
            int scale = fieldMetadata.getScale();
            ArrayNode arrayNode = (ArrayNode)OBJECT_MAPPER.readTree(arrayString);
            Iterator<JsonNode> nodeElements = arrayNode.elements();
            switch (columnType) {
                case 4: {
                    return new SfSqlArray(arrayString, columnSubType, this.getStream(nodeElements, this.getConverters().integerConverter(columnType)).toArray(Integer[]::new));
                }
                case 5: {
                    return new SfSqlArray(arrayString, columnSubType, this.getStream(nodeElements, this.getConverters().smallIntConverter(columnType)).toArray(Short[]::new));
                }
                case -6: {
                    return new SfSqlArray(arrayString, columnSubType, this.getStream(nodeElements, this.getConverters().tinyIntConverter(columnType)).toArray(Byte[]::new));
                }
                case -5: {
                    return new SfSqlArray(arrayString, columnSubType, this.getStream(nodeElements, this.getConverters().bigIntConverter(columnType)).toArray(Long[]::new));
                }
                case 2: 
                case 3: {
                    return new SfSqlArray(arrayString, columnSubType, this.convertToFixedArray(this.getStream(nodeElements, this.getConverters().bigDecimalConverter(columnType))));
                }
                case -16: 
                case 1: 
                case 12: {
                    return new SfSqlArray(arrayString, columnSubType, this.getStream(nodeElements, this.getConverters().varcharConverter(columnType, columnSubType, scale)).toArray(String[]::new));
                }
                case -2: {
                    return new SfSqlArray(arrayString, columnSubType, this.getStream(nodeElements, this.getConverters().bytesConverter(columnType, scale)).toArray(x$0 -> new Byte[x$0][]));
                }
                case 6: 
                case 7: {
                    return new SfSqlArray(arrayString, columnSubType, this.getStream(nodeElements, this.getConverters().floatConverter(columnType)).toArray(Float[]::new));
                }
                case 8: {
                    return new SfSqlArray(arrayString, columnSubType, this.getStream(nodeElements, this.getConverters().doubleConverter(columnType)).toArray(Double[]::new));
                }
                case 91: {
                    return new SfSqlArray(arrayString, columnSubType, this.getStream(nodeElements, this.getConverters().dateStringConverter(this.session)).toArray(Date[]::new));
                }
                case 92: {
                    return new SfSqlArray(arrayString, columnSubType, this.getStream(nodeElements, this.getConverters().timeFromStringConverter(this.session)).toArray(Time[]::new));
                }
                case 93: {
                    return new SfSqlArray(arrayString, columnSubType, this.getStream(nodeElements, this.getConverters().timestampFromStringConverter(columnSubType, columnType, scale, this.session, null, this.sessionTimeZone)).toArray(Timestamp[]::new));
                }
                case 16: {
                    return new SfSqlArray(arrayString, columnSubType, this.getStream(nodeElements, this.getConverters().booleanConverter(columnType)).toArray(Boolean[]::new));
                }
                case 2002: {
                    return new SfSqlArray(arrayString, columnSubType, this.getStream(nodeElements, this.getConverters().structConverter(OBJECT_MAPPER)).toArray(Map[]::new));
                }
                case 2003: {
                    return new SfSqlArray(arrayString, columnSubType, this.getStream(nodeElements, this.getConverters().arrayConverter(OBJECT_MAPPER)).toArray(x$0 -> new Map[x$0][]));
                }
            }
            throw new SFException(ErrorCode.FEATURE_UNSUPPORTED, "Can't construct array for data type: " + columnSubType);
        }
        catch (JsonProcessingException e) {
            throw new SFException(e, ErrorCode.INVALID_STRUCT_DATA, new Object[0]);
        }
    }

    @SnowflakeJdbcInternalApi
    protected Date convertStringToDate(String object, TimeZone tz) throws SFException {
        return (Date)this.getConverters().dateStringConverter(this.session).convert(object);
    }

    @SnowflakeJdbcInternalApi
    protected Time convertStringToTime(String object, int scale) throws SFException {
        return (Time)this.getConverters().timeFromStringConverter(this.session).convert(object);
    }

    @SnowflakeJdbcInternalApi
    protected Timestamp convertStringToTimestamp(String object, int columnType, int columnSubType, TimeZone tz, int scale) throws SFException {
        return (Timestamp)this.getConverters().timestampFromStringConverter(columnSubType, columnType, scale, this.session, null, tz).convert(object);
    }

    private Stream getStream(Iterator nodeElements, Converter converter) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(nodeElements, 16), false).map(elem -> {
            try {
                return SFBaseResultSet.convert(converter, (JsonNode)elem);
            }
            catch (SFException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static Object convert(Converter converter, JsonNode node) throws SFException {
        String nodeValue = SnowflakeUtil.getJsonNodeStringValue(node);
        return converter.convert(nodeValue);
    }

    private Object[] convertToFixedArray(Stream inputStream) {
        AtomicInteger bigDecimalCount = new AtomicInteger();
        Object[] elements = inputStream.peek(elem -> {
            if (elem instanceof BigDecimal) {
                bigDecimalCount.incrementAndGet();
            }
        }).toArray(size -> {
            boolean shouldReturnAsBigDecimal = bigDecimalCount.get() > 0;
            Class returnedClass = shouldReturnAsBigDecimal ? BigDecimal.class : Long.class;
            return Array.newInstance(returnedClass, size);
        });
        return elements;
    }
}

