/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.grpc;

import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ListenableFutureToApiFuture;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcClientCalls;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.ApiCallContext;
import net.snowflake.client.jdbc.internal.google.api.gax.rpc.UnaryCallable;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.grpc.ClientCall;
import net.snowflake.client.jdbc.internal.grpc.MethodDescriptor;
import net.snowflake.client.jdbc.internal.grpc.stub.ClientCalls;

class GrpcDirectCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final MethodDescriptor<RequestT, ResponseT> descriptor;
    private final boolean awaitTrailers;

    GrpcDirectCallable(MethodDescriptor<RequestT, ResponseT> descriptor, boolean awaitTrailers) {
        this.descriptor = Preconditions.checkNotNull(descriptor);
        this.awaitTrailers = awaitTrailers;
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        Preconditions.checkNotNull(request);
        Preconditions.checkNotNull(inputContext);
        ClientCall<RequestT, ResponseT> clientCall = GrpcClientCalls.newCall(this.descriptor, inputContext);
        if (this.awaitTrailers) {
            return new ListenableFutureToApiFuture<ResponseT>(ClientCalls.futureUnaryCall(clientCall, request));
        }
        return GrpcClientCalls.eagerFutureUnaryCall(clientCall, request);
    }

    public String toString() {
        return String.format("direct(%s)", this.descriptor);
    }
}

