/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.gax.retrying;

import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutures;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.core.ListenableFutureToApiFuture;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.CallbackChainRetryingFuture;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.NoopRetryingContext;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.RetryAlgorithm;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.RetryingContext;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.RetryingExecutorWithContext;
import net.snowflake.client.jdbc.internal.google.api.gax.retrying.RetryingFuture;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.ListenableScheduledFuture;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.ListeningScheduledExecutorService;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.MoreExecutors;

public class ScheduledRetryingExecutor<ResponseT>
implements RetryingExecutorWithContext<ResponseT> {
    private final RetryAlgorithm<ResponseT> retryAlgorithm;
    private final ListeningScheduledExecutorService scheduler;

    public ScheduledRetryingExecutor(RetryAlgorithm<ResponseT> retryAlgorithm, ScheduledExecutorService scheduler) {
        this.retryAlgorithm = retryAlgorithm;
        this.scheduler = MoreExecutors.listeningDecorator((ScheduledExecutorService)scheduler);
    }

    @Override
    public RetryingFuture<ResponseT> createFuture(Callable<ResponseT> callable) {
        return this.createFuture(callable, NoopRetryingContext.create());
    }

    @Override
    @BetaApi(value="The surface for passing per operation state is not yet stable")
    public RetryingFuture<ResponseT> createFuture(Callable<ResponseT> callable, RetryingContext context) {
        return new CallbackChainRetryingFuture<ResponseT>(callable, this.retryAlgorithm, this, context);
    }

    @Override
    public ApiFuture<ResponseT> submit(RetryingFuture<ResponseT> retryingFuture) {
        try {
            ListenableScheduledFuture attemptFuture = this.scheduler.schedule(retryingFuture.getCallable(), retryingFuture.getAttemptSettings().getRandomizedRetryDelay().toMillis(), TimeUnit.MILLISECONDS);
            return new ListenableFutureToApiFuture(attemptFuture);
        }
        catch (RejectedExecutionException e) {
            return ApiFutures.immediateFailedFuture(e);
        }
    }
}

