/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.api.core;

import java.util.List;
import java.util.concurrent.Executor;
import net.snowflake.client.jdbc.internal.google.api.core.AbstractApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiAsyncFunction;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFunction;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutureCallback;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutureToListenableFuture;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.core.ListenableFutureToApiFuture;
import net.snowflake.client.jdbc.internal.google.common.base.Function;
import net.snowflake.client.jdbc.internal.google.common.collect.Iterables;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.AsyncFunction;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.FutureCallback;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.Futures;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.ListenableFuture;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.MoreExecutors;
import net.snowflake.client.jdbc.internal.javax.annotation.Nullable;

public final class ApiFutures {
    private ApiFutures() {
    }

    @Deprecated
    public static <V> void addCallback(ApiFuture<V> future, ApiFutureCallback<? super V> callback) {
        ApiFutures.addCallback(future, callback, MoreExecutors.directExecutor());
    }

    public static <V> void addCallback(ApiFuture<V> future, final ApiFutureCallback<? super V> callback, Executor executor) {
        Futures.addCallback(ApiFutures.listenableFutureForApiFuture(future), (FutureCallback)new FutureCallback<V>(){

            public void onFailure(Throwable t) {
                callback.onFailure(t);
            }

            public void onSuccess(V v) {
                callback.onSuccess(v);
            }
        }, (Executor)executor);
    }

    @Deprecated
    public static <V, X extends Throwable> ApiFuture<V> catching(ApiFuture<? extends V> input, Class<X> exceptionType, ApiFunction<? super X, ? extends V> callback) {
        return ApiFutures.catching(input, exceptionType, callback, MoreExecutors.directExecutor());
    }

    public static <V, X extends Throwable> ApiFuture<V> catching(ApiFuture<? extends V> input, Class<X> exceptionType, ApiFunction<? super X, ? extends V> callback, Executor executor) {
        ListenableFuture catchingFuture = Futures.catching(ApiFutures.listenableFutureForApiFuture(input), exceptionType, new ApiFunctionToGuavaFunction<X, V>(callback), (Executor)executor);
        return new ListenableFutureToApiFuture(catchingFuture);
    }

    @BetaApi
    public static <V, X extends Throwable> ApiFuture<V> catchingAsync(ApiFuture<V> input, Class<X> exceptionType, final ApiAsyncFunction<? super X, V> callback, Executor executor) {
        ListenableFuture catchingFuture = Futures.catchingAsync(ApiFutures.listenableFutureForApiFuture(input), exceptionType, (AsyncFunction)new AsyncFunction<X, V>(){

            public ListenableFuture<V> apply(X exception) throws Exception {
                ApiFuture result = callback.apply(exception);
                return ApiFutures.listenableFutureForApiFuture(result);
            }
        }, (Executor)executor);
        return new ListenableFutureToApiFuture(catchingFuture);
    }

    public static <V> ApiFuture<V> immediateFuture(V value) {
        return new ListenableFutureToApiFuture(Futures.immediateFuture(value));
    }

    public static <V> ApiFuture<V> immediateFailedFuture(Throwable throwable) {
        return new ListenableFutureToApiFuture(Futures.immediateFailedFuture((Throwable)throwable));
    }

    public static <V> ApiFuture<V> immediateCancelledFuture() {
        return new ListenableFutureToApiFuture(Futures.immediateCancelledFuture());
    }

    @Deprecated
    public static <V, X> ApiFuture<X> transform(ApiFuture<? extends V> input, ApiFunction<? super V, ? extends X> function) {
        return ApiFutures.transform(input, function, MoreExecutors.directExecutor());
    }

    public static <V, X> ApiFuture<X> transform(ApiFuture<? extends V> input, ApiFunction<? super V, ? extends X> function, Executor executor) {
        return new ListenableFutureToApiFuture(Futures.transform(ApiFutures.listenableFutureForApiFuture(input), new ApiFunctionToGuavaFunction<V, X>(function), (Executor)executor));
    }

    public static <V> ApiFuture<List<V>> allAsList(Iterable<? extends ApiFuture<? extends V>> futures) {
        return new ListenableFutureToApiFuture<List<V>>(Futures.allAsList(Iterables.transform(futures, new Function<ApiFuture<? extends V>, ListenableFuture<? extends V>>(){

            @Override
            public ListenableFuture<? extends V> apply(ApiFuture<? extends V> apiFuture) {
                return ApiFutures.listenableFutureForApiFuture(apiFuture);
            }
        })));
    }

    @BetaApi
    public static <V> ApiFuture<List<V>> successfulAsList(Iterable<? extends ApiFuture<? extends V>> futures) {
        return new ListenableFutureToApiFuture<List<V>>(Futures.successfulAsList(Iterables.transform(futures, new Function<ApiFuture<? extends V>, ListenableFuture<? extends V>>(){

            @Override
            public ListenableFuture<? extends V> apply(ApiFuture<? extends V> apiFuture) {
                return ApiFutures.listenableFutureForApiFuture(apiFuture);
            }
        })));
    }

    @Deprecated
    public static <I, O> ApiFuture<O> transformAsync(ApiFuture<I> input, ApiAsyncFunction<I, O> function) {
        return ApiFutures.transformAsync(input, function, MoreExecutors.directExecutor());
    }

    public static <I, O> ApiFuture<O> transformAsync(ApiFuture<I> input, final ApiAsyncFunction<I, O> function, Executor executor) {
        ListenableFuture<I> listenableInput = ApiFutures.listenableFutureForApiFuture(input);
        ListenableFuture listenableOutput = Futures.transformAsync(listenableInput, (AsyncFunction)new AsyncFunction<I, O>(){

            public ListenableFuture<O> apply(I input) throws Exception {
                return ApiFutures.listenableFutureForApiFuture(function.apply(input));
            }
        }, (Executor)executor);
        return new ListenableFutureToApiFuture(listenableOutput);
    }

    private static <V> ListenableFuture<V> listenableFutureForApiFuture(ApiFuture<V> apiFuture) {
        Object listenableFuture = apiFuture instanceof AbstractApiFuture ? ((AbstractApiFuture)apiFuture).getInternalListenableFuture() : new ApiFutureToListenableFuture<V>(apiFuture);
        return listenableFuture;
    }

    private static class ApiFunctionToGuavaFunction<X, V>
    implements Function<X, V> {
        private ApiFunction<? super X, ? extends V> f;

        public ApiFunctionToGuavaFunction(ApiFunction<? super X, ? extends V> f) {
            this.f = f;
        }

        @Override
        @Nullable
        public V apply(@Nullable X input) {
            return this.f.apply(input);
        }
    }
}

