/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.endpointdiscovery;

import java.io.File;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkTestInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.AllProfiles;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.AwsProfileNameLoader;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.BasicProfile;
import net.snowflake.client.jdbc.internal.amazonaws.auth.profile.internal.BasicProfileConfigLoader;
import net.snowflake.client.jdbc.internal.amazonaws.endpointdiscovery.EndpointDiscoveryProvider;
import net.snowflake.client.jdbc.internal.amazonaws.profile.path.AwsProfileFileLocationProvider;
import net.snowflake.client.jdbc.internal.amazonaws.util.StringUtils;

public class AwsProfileEndpointDiscoveryProvider
implements EndpointDiscoveryProvider {
    private final String profileName;
    private final AwsProfileFileLocationProvider locationProvider;
    private final BasicProfileConfigLoader profileConfigLoader;

    public AwsProfileEndpointDiscoveryProvider() {
        this(AwsProfileNameLoader.INSTANCE.loadProfileName());
    }

    public AwsProfileEndpointDiscoveryProvider(String profileName) {
        this(profileName, AwsProfileFileLocationProvider.DEFAULT_CONFIG_LOCATION_PROVIDER, BasicProfileConfigLoader.INSTANCE);
    }

    @SdkTestInternalApi
    AwsProfileEndpointDiscoveryProvider(String profileName, AwsProfileFileLocationProvider locationProvider, BasicProfileConfigLoader configLoader) {
        this.profileName = profileName;
        this.locationProvider = locationProvider;
        this.profileConfigLoader = configLoader;
    }

    @Override
    public boolean endpointDiscoveryEnabled() {
        BasicProfile profile;
        File configFile = this.locationProvider.getLocation();
        if (configFile != null && configFile.exists() && (profile = this.loadProfile(configFile)) != null && !StringUtils.isNullOrEmpty(profile.getEndpointDiscovery())) {
            try {
                return Boolean.parseBoolean(profile.getEndpointDiscovery());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to parse value for aws_enable_endpoint_discovery");
            }
        }
        return false;
    }

    private BasicProfile loadProfile(File configFile) {
        AllProfiles allProfiles = this.profileConfigLoader.loadProfiles(configFile);
        return allProfiles.getProfile(this.profileName);
    }
}

