/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.snowflake.common.util.FixedViewColumn;

public class ClassUtil {
    public static Field[] getDeclaredFields(Class clazz, boolean recursively) {
        Field[] declaredFieldsOfSuper;
        LinkedList fields = new LinkedList();
        Field[] declaredFields = clazz.getDeclaredFields();
        Collections.addAll(fields, declaredFields);
        Class superClass = clazz.getSuperclass();
        if (superClass != null && recursively && (declaredFieldsOfSuper = ClassUtil.getDeclaredFields(superClass, recursively)).length > 0) {
            Collections.addAll(fields, declaredFieldsOfSuper);
        }
        return fields.toArray(new Field[fields.size()]);
    }

    public static Field[] getAnnotatedDeclaredFields(Class clazz, Class<? extends Annotation> annotationClass, boolean recursively) {
        Field[] allFields = ClassUtil.getDeclaredFields(clazz, recursively);
        LinkedList<Field> annotatedFields = new LinkedList<Field>();
        for (Field field : allFields) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            annotatedFields.add(field);
        }
        return annotatedFields.toArray(new Field[annotatedFields.size()]);
    }

    public static List<Object> getFixedViewObjectAsRow(Class clazz, Object object) throws Exception {
        Field[] columns = ClassUtil.getAnnotatedDeclaredFields(clazz, FixedViewColumn.class, true);
        Arrays.sort(columns, new FixedViewColumn.OrdinalComparatorForFields());
        ArrayList<Object> row = new ArrayList<Object>(columns.length);
        for (Field column : columns) {
            column.setAccessible(true);
            Object columnObj = column.get(object);
            if (columnObj != null) {
                row.add(columnObj.toString());
                continue;
            }
            row.add(columnObj);
        }
        return row;
    }
}

