/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.common.core;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.snowflake.common.core.CalendarCache;

public abstract class SFInstant {
    public static final int DAY_OF_WEEK_ISO = 10001;
    protected static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    protected static final int[] POWERS_OF_TEN = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};

    public abstract int extract(int var1);

    protected int extract(int field, TimeZone tz, long time) {
        int era;
        GregorianCalendar calendar = CalendarCache.get(tz);
        calendar.setFirstDayOfWeek(2);
        calendar.setMinimalDaysInFirstWeek(4);
        calendar.setTimeInMillis(time);
        int val = field == 10001 ? calendar.get(7) : calendar.get(field);
        if (field == 2) {
            ++val;
        } else if (field == 7) {
            --val;
        } else if (field == 10001) {
            val = (val + 5) % 7 + 1;
        } else if (field == 1 && (era = calendar.get(0)) == 0) {
            val = -val;
        }
        return val;
    }
}

