/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.common.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.snowflake.common.core.SFInstant;
import net.snowflake.common.core.SFTimestamp;

public class SFDate
extends SFInstant {
    private final Date date;

    public Date getDate() {
        return this.date;
    }

    public int hashCode() {
        return this.date.hashCode();
    }

    public long getTime() {
        return this.date.getTime();
    }

    public String toUTCString() {
        TimeZone dtz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        df.setTimeZone(dtz);
        return df.format(this.date.getTime());
    }

    public int compareTo(SFDate other) {
        return this.date.compareTo(other.date);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SFDate)) {
            return false;
        }
        return this.equals((SFDate)o);
    }

    public boolean equals(SFDate other) {
        return this.date.equals(other.date);
    }

    public SFDate(long millis) {
        this.date = SFDate.normalize(millis, null);
    }

    public SFDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Illegal null date parameter.");
        }
        this.date = SFDate.normalize(date.getTime(), null);
    }

    public SFDate(SFDate sfd) {
        this.date = (Date)sfd.date.clone();
    }

    public static SFDate fromTimestamp(SFTimestamp timestamp) {
        long millis = timestamp.getTime();
        TimeZone tz = timestamp.getTimeZone();
        return new SFDate(SFDate.normalize(millis, tz));
    }

    private static Date normalize(long millis, TimeZone tz) {
        if (tz != null) {
            millis += (long)tz.getOffset(millis);
        }
        double MILLIS_IN_DAY = 8.64E7;
        double dblMS = millis;
        dblMS = Math.floor(dblMS / 8.64E7) * 8.64E7;
        millis = (long)dblMS;
        return new Date(millis);
    }

    @Override
    public int extract(int field) {
        return this.extract(field, SFInstant.GMT, this.date.getTime());
    }

    public String toString() {
        return "SFDate(date='" + this.date + "')";
    }
}

