/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.common.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Map;
import net.snowflake.common.core.ClientAuthnParameter;
import net.snowflake.common.core.ResourceBundleManager;
import net.snowflake.common.core.SubmittedAuthnDTO;

public class ClientAuthnDTO
implements SubmittedAuthnDTO {
    private Map<String, Object> data;
    private String inFlightCtx;
    private static final ResourceBundleManager versionResourceBundleManager = ResourceBundleManager.getSingleton("net.snowflake.common.version");

    public Map<String, Object> getData() {
        return this.data;
    }

    public void setData(Map<String, Object> data) {
        this.data = data;
    }

    @Override
    public String getInFlightCtx() {
        return this.inFlightCtx;
    }

    public void setInFlightCtx(String inFlightCtx) {
        this.inFlightCtx = inFlightCtx;
    }

    @JsonIgnore
    public String getLoginName() {
        return this.getParamAsString(ClientAuthnParameter.LOGIN_NAME.name());
    }

    @JsonIgnore
    public String getPassword() {
        return this.getParamAsString(ClientAuthnParameter.PASSWORD.name());
    }

    @JsonIgnore
    public String getSamlResponse() {
        return this.getParamAsString(ClientAuthnParameter.SAML_RESPONSE.name());
    }

    @JsonIgnore
    public String getRawSamlResponse() {
        return this.getParamAsString(ClientAuthnParameter.RAW_SAML_RESPONSE.name());
    }

    @JsonIgnore
    public String getAccountName() {
        return this.getParamAsString(ClientAuthnParameter.ACCOUNT_NAME.name());
    }

    @JsonIgnore
    public String getClientAppId() {
        return this.getParamAsNonNullString(ClientAuthnParameter.CLIENT_APP_ID.name());
    }

    @JsonIgnore
    public String getClientAppVersion() {
        return this.getParamAsNonNullString(ClientAuthnParameter.CLIENT_APP_VERSION.name());
    }

    @JsonIgnore
    public String getChosenNewPassword() {
        return this.getParamAsString(ClientAuthnParameter.CHOSEN_NEW_PASSWORD.name());
    }

    @JsonIgnore
    public String getClientBuildId() {
        String clientBuildId = this.getParamAsString(ClientAuthnParameter.CLIENT_BUILD_ID.name());
        if (clientBuildId != null) {
            return clientBuildId;
        }
        return this.getParamAsString(ClientAuthnParameter.SVN_REVISION.name());
    }

    @JsonIgnore
    public static String getLatestJDBCAppVersion() {
        return versionResourceBundleManager.getLocalizedMessage("jdbc.version");
    }

    @JsonIgnore
    public static String getLatestODBCAppVersion() {
        return versionResourceBundleManager.getLocalizedMessage("odbc.version");
    }

    @JsonIgnore
    public boolean isLicenseAccepted() {
        Object o = this.getParam(ClientAuthnParameter.LICENSE_ACCEPTED.name());
        if (o != null) {
            return (Boolean)o;
        }
        return false;
    }

    @JsonIgnore
    public String getExtAuthnMethod() {
        return this.getParamAsString(ClientAuthnParameter.EXT_AUTHN_DUO_METHOD.name());
    }

    @JsonIgnore
    public String getPasscode() {
        return this.getParamAsString(ClientAuthnParameter.PASSCODE.name());
    }

    @JsonIgnore
    public String getOldMasterToken() {
        return this.getParamAsString(ClientAuthnParameter.OLD_MASTER_TOKEN.name());
    }

    @JsonIgnore
    public String getOldSessionToken() {
        return this.getParamAsString(ClientAuthnParameter.OLD_SESSION_TOKEN.name());
    }

    @JsonIgnore
    public RequestType getRequestType() {
        Object o = this.getParam(ClientAuthnParameter.REQUEST_TYPE.name());
        return this.valueOf(RequestType.class, o);
    }

    @JsonIgnore
    public ReauthnType getReauthnType() {
        Object o = this.getParam(ClientAuthnParameter.REAUTHENTICATION_TYPE.name());
        return this.valueOf(ReauthnType.class, o);
    }

    @JsonIgnore
    public String getAuthnRequestId() {
        return this.getParamAsString(ClientAuthnParameter.AUTHENTICATION_REQUEST_ID.name());
    }

    @JsonIgnore
    public String getAuthnMethod() {
        return this.getParamAsString(ClientAuthnParameter.AUTHENTICATION_METHOD.name());
    }

    @JsonIgnore
    public Map<String, Object> getClientEnvironment() {
        return (Map)this.getParam(ClientAuthnParameter.CLIENT_ENVIRONMENT.name());
    }

    @JsonIgnore
    public Map<String, Object> getSessionParameters() {
        return (Map)this.getParam(ClientAuthnParameter.SESSION_PARAMETERS.name());
    }

    @JsonIgnore
    public String getReauthPendingCount() {
        return this.getParamAsString(ClientAuthnParameter.FED_REAUTH_PENDING_COUNT.name());
    }

    @JsonIgnore
    public String getAuthenticator() {
        return this.getParamAsString(ClientAuthnParameter.AUTHENTICATOR.name());
    }

    @JsonIgnore
    public String getJwtToken() {
        return this.getParamAsString(ClientAuthnParameter.JWT_TOKEN.name());
    }

    private String getParamAsString(String param) {
        Object obj = this.getParam(param);
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }

    private String getParamAsNonNullString(String param) {
        String s = this.getParamAsString(param);
        return s != null ? s : "";
    }

    private Object getParam(String param) {
        if (this.data != null) {
            return this.data.get(param);
        }
        return null;
    }

    private <T extends Enum<T>> T valueOf(Class<T> enumType, Object o) {
        if (o != null) {
            try {
                return Enum.valueOf(enumType, o.toString());
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    public static enum AuthenticatorType {
        SNOWFLAKE,
        OKTA;

    }

    public static enum ReauthnType {
        USERNAME_PASSWORD,
        MFA,
        FEDERATED,
        FEDERATED_MFA;

    }

    public static enum RequestType {
        RENEW,
        CLONE,
        ISSUE;

    }
}

