/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.utilities.java.support.codec;

import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.DeprecationSupport;
import net.shibboleth.shared.primitive.DeprecationSupport.ObjectType;

/**
 * Deprecated stub.
 * 
 * @deprecated
 */
@Deprecated(since="9.0.0", forRemoval=true)
public final class StringDigester extends net.shibboleth.shared.codec.StringDigester {
    
    /**
     * Constructor.
     * 
     * <p>The input character set will be UTF-8.</p>
     *
     * @param algorithm the JCA digest algorithm identifier
     * @param format the output format used to convert the digested[] to the output string
     * @throws NoSuchAlgorithmException thrown if the digestAlgorithm is not invalid or unsupported
     */
    public StringDigester(@Nonnull @NotEmpty @ParameterName(name="algorithm") final String algorithm, 
            @Nonnull @ParameterName(name="format") final OutputFormat format) 
            throws NoSuchAlgorithmException {
       super(algorithm, format);
       DeprecationSupport.warn(ObjectType.CLASS, getClass().getName(), null,
               net.shibboleth.shared.codec.StringDigester.class.getName());
    }
    
    /**
     * Constructor.
     *
     * @param algorithm the JCA digest algorithm identifier
     * @param format the output format used to convert the digested[] to the output string
     * @param charset the character set to use in converting the input string to a byte[] prior to digesting
     * @throws NoSuchAlgorithmException thrown if the digestAlgorithm is not invalid or unsupported
     */
    public StringDigester(@Nonnull @NotEmpty @ParameterName(name="algorithm") final String algorithm, 
            @Nonnull @ParameterName(name="format") final OutputFormat format, 
            @Nullable @ParameterName(name="charset") final Charset charset) throws NoSuchAlgorithmException {
        super(algorithm, format, charset);
        DeprecationSupport.warn(ObjectType.CLASS, getClass().getName(), null,
                net.shibboleth.shared.codec.StringDigester.class.getName());
    }

}