/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.servlet.impl;

import javax.annotation.Nonnull;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import net.shibboleth.shared.servlet.HttpServletRequestValidator;

/**
 * Implementation of {@link HttpServletRequestValidator} which is always valid.
 */
public class NoOpHttpServletRequestValidator implements HttpServletRequestValidator {

    /** {@inheritDoc} */
    @Override
    public void validate(@Nonnull final HttpServletRequest request) throws ServletException {
        // Intentionally unimplemented
    }

}
