/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.cli;

import com.beust.jcommander.JCommander;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.cli.CommandLineArguments;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.shared.spring.resource.PreferFileSystemResourceLoader;
import net.shibboleth.shared.spring.util.ApplicationContextBuilder;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePropertySource;

public abstract class AbstractCommandLine<T extends CommandLineArguments> {
    @Nonnull
    @NotEmpty
    public static final String ARGS_PROPERTY = "net.shibboleth.shared.cli.arguments";
    public static final int RC_OK = 0;
    public static final int RC_INIT = 1;
    public static final int RC_IO = 2;
    public static final int RC_UNKNOWN = -1;
    private boolean caseSensitiveOptions = true;
    @Nullable
    private GenericApplicationContext applicationContext;
    @Nullable
    private ApplicationContextInitializer<? super FilesystemGenericApplicationContext> contextInitializer;

    protected void setCaseSensitiveOptions(boolean flag) {
        this.caseSensitiveOptions = flag;
    }

    protected void setContextInitializer(@Nonnull ApplicationContextInitializer<? super FilesystemGenericApplicationContext> initializer) {
        this.contextInitializer = (ApplicationContextInitializer)Constraint.isNotNull(initializer, (String)"Injected ContextInitializer cannot be null");
    }

    @Nonnull
    protected GenericApplicationContext getApplicationContext() {
        if (this.applicationContext != null) {
            return this.applicationContext;
        }
        throw new IllegalStateException("No application context installed");
    }

    @Nonnull
    @Unmodifiable
    @NotLive
    protected List<Resource> getAdditionalSpringResources() {
        return CollectionSupport.emptyList();
    }

    protected int run(@Nonnull String[] args) {
        CommandLineArguments argObject;
        try {
            Constructor<T> construct = this.getArgumentClass().getConstructor(new Class[0]);
            argObject = (CommandLineArguments)construct.newInstance(new Object[0]);
            JCommander jc = new JCommander((Object)argObject);
            jc.setCaseSensitiveOptions(this.caseSensitiveOptions);
            jc.parse(args);
            if (argObject.isHelp()) {
                argObject.printHelp(System.out);
                return 0;
            }
            if (argObject.isVersion()) {
                System.out.println(this.getVersion());
                return 0;
            }
            this.initLogging(argObject);
            argObject.validate();
        }
        catch (Exception e) {
            String msg = e.getLocalizedMessage();
            if (msg != null) {
                AbstractCommandLine.error(msg);
            } else {
                AbstractCommandLine.error("Exception with no message: " + e.getClass().getName());
            }
            return 1;
        }
        return this.doRun(argObject);
    }

    private void setLoggingProperty(@Nonnull String value) {
        System.setProperty("logback.configurationFile", value);
    }

    private void setLoggingToLocalResource(@Nonnull String value) {
        this.setLoggingProperty("net/shibboleth/shared/cli/" + value);
    }

    protected void initLogging(@Nonnull T args) {
        String lc = args.getLoggingConfiguration();
        if (lc != null) {
            this.setLoggingProperty(lc);
        } else if (args.isVerboseOutput()) {
            this.setLoggingToLocalResource("logger-verbose.xml");
        } else if (args.isQuietOutput()) {
            this.setLoggingToLocalResource("logger-quiet.xml");
        } else {
            this.setLoggingToLocalResource("logger-normal.xml");
        }
    }

    protected int doRun(@Nonnull T args) {
        try {
            PreferFileSystemResourceLoader loader = new PreferFileSystemResourceLoader();
            List<Resource> additionalConfigs = this.getAdditionalSpringResources();
            ArrayList<Resource> configs = new ArrayList<Resource>(1 + additionalConfigs.size());
            if (args.getOtherArgs().size() > 0) {
                configs.add(loader.getResource(args.getOtherArgs().get(0)));
            }
            configs.addAll(additionalConfigs);
            this.getLogger().debug("Initializing Spring context with {}", configs);
            List resources = (List)((NonnullSupplier)args.getPropertyFiles().stream().map(arg_0 -> ((ResourceLoader)loader).getResource(arg_0)).collect(CollectionSupport.nonnullCollector(Collectors.toUnmodifiableList()))).get();
            ArrayList propertySources = new ArrayList(resources.size());
            resources.forEach(r -> {
                try {
                    assert (r != null);
                    propertySources.add(new ResourcePropertySource(r));
                }
                catch (IOException e) {
                    if (args.isVerboseOutput()) {
                        this.getLogger().error("Unable to load properties from {}", r, (Object)e);
                    }
                    this.getLogger().error("Unable to load properties from {}", r, (Object)e.getMessage());
                }
            });
            ApplicationContextBuilder builder = new ApplicationContextBuilder().setServiceConfigurations(configs).setPropertySources(propertySources);
            if (this.contextInitializer != null) {
                builder.setContextInitializer(this.contextInitializer);
            }
            this.applicationContext = builder.build();
            this.applicationContext.registerShutdownHook();
        }
        catch (Exception e) {
            if (args.isVerboseOutput()) {
                this.getLogger().error("Unable to initialize Spring context", (Throwable)e);
            } else {
                this.getLogger().error("Unable to initialize Spring context", (Object)e.getMessage());
            }
            return 1;
        }
        return 0;
    }

    @Nonnull
    protected abstract Class<T> getArgumentClass();

    @Nonnull
    @NotEmpty
    protected abstract String getVersion();

    @Nonnull
    protected abstract Logger getLogger();

    private static void error(@Nonnull @NotEmpty String error) {
        System.err.println(error);
        System.err.flush();
        System.out.println();
        System.out.flush();
    }

    public static enum TerminalCodes {
        RESET("\u001b[0m"),
        BLACK("\u001b[30m"),
        RED("\u001b[31m"),
        GREEN("\u001b[32m"),
        YELLOW("\u001b[33m"),
        BLUE("\u001b[34m"),
        PURPLE("\u001b[35m"),
        CYAN("\u001b[36m"),
        WHITE("\u001b[37m");

        @Nonnull
        @NotEmpty
        private final String ansicode;

        private TerminalCodes(String ansi) {
            this.ansicode = ansi;
        }

        public String code(@Nonnull CommandLineArguments args) {
            return args.isANSI() ? this.ansicode : "";
        }
    }
}

