/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.net.URI;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestRedirectURILookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultValidRedirectUrisLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateRedirectURI
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateRedirectURI.class);
    @Nonnull
    private Function<ProfileRequestContext, URI> redirectURILookupStrategy = new DefaultRequestRedirectURILookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Set<URI>> validRedirectURIsLookupStrategy = new DefaultValidRedirectUrisLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Set<URI>> registeredRedirectURIsLookupStrategy = new DefaultValidRedirectUrisLookupFunction();
    private boolean requireRequestedValue = true;

    public void setRedirectURILookupStrategy(@Nonnull Function<ProfileRequestContext, URI> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.redirectURILookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RedirectURILookupStrategy lookup strategy cannot be null");
    }

    public void setValidRedirectURIsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<URI>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.validRedirectURIsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ValidRedirectURIsLookupStrategy lookup strategy cannot be null");
    }

    public void setRegisteredRedirectURIsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<URI>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.registeredRedirectURIsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RegisteredRedirectURIsLookupStrategy lookup strategy cannot be null");
    }

    public void setRequireRequestedValue(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requireRequestedValue = flag;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        URI requestRedirectURI = this.redirectURILookupStrategy.apply(profileRequestContext);
        Set<URI> redirectionURIs = this.validRedirectURIsLookupStrategy.apply(profileRequestContext);
        if (redirectionURIs == null || redirectionURIs.isEmpty()) {
            this.log.warn("{} Client has not registered Redirection URIs. Redirection URI cannot be validated.", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURI");
            return;
        }
        if (requestRedirectURI == null) {
            this.handleNullRequestedURI(profileRequestContext, redirectionURIs);
            return;
        }
        if (redirectionURIs.contains(requestRedirectURI)) {
            this.getOidcResponseContext().setRedirectURI(requestRedirectURI);
            this.log.debug("{} Redirection URI validated {}", (Object)this.getLogPrefix(), (Object)requestRedirectURI);
            return;
        }
        Object registered = "";
        for (URI uri : redirectionURIs) {
            registered = (String)registered + (String)(((String)registered).isEmpty() ? uri.toString() : ", " + uri.toString());
        }
        this.log.error("{} Redirection URI {} not matching any of the registered Redirection URIs [{}] ", new Object[]{this.getLogPrefix(), requestRedirectURI.toString(), registered});
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURI");
    }

    protected void handleNullRequestedURI(ProfileRequestContext profileRequestContext, @Nonnull @NotEmpty Set<URI> validRedirectionURIs) {
        if (this.requireRequestedValue) {
            this.log.warn("{} Redirection URI of the request not located for verification", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURI");
            return;
        }
        Set<URI> registeredURIs = this.registeredRedirectURIsLookupStrategy.apply(profileRequestContext);
        if (registeredURIs == null || registeredURIs.isEmpty()) {
            this.log.warn("{} Client has not registered Redirection URIs. Redirection URI cannot be validated.", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURI");
            return;
        }
        if (registeredURIs.size() == 1 && validRedirectionURIs.size() == 1) {
            URI singleValidUri;
            URI singleRegisteredUri = registeredURIs.iterator().next();
            if (singleRegisteredUri.equals(singleValidUri = validRedirectionURIs.iterator().next())) {
                this.log.debug("{} No requested redirect_uri found, but allowing it due to single trusted value {}", (Object)this.getLogPrefix(), (Object)singleRegisteredUri);
                this.getOidcResponseContext().setRedirectURI(singleRegisteredUri);
                return;
            }
            this.log.warn("{} Registered URI '{}' did not match with the valid one '{}'", new Object[]{this.getLogPrefix(), singleRegisteredUri, singleValidUri});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURI");
            return;
        }
        this.log.warn("{} Redirection URI of the request missing even though multiple values registered/valid", (Object)this.getLogPrefix());
        ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRedirectionURI");
    }
}

