/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import java.text.ParseException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetRequestedSubjectToResponseContext
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetRequestedSubjectToResponseContext.class);
    @Nonnull
    private Collection<ClaimsSetRequest.Entry> idTokenClaims;
    @Nullable
    private JWT idTokenHint;

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCClaimsRequest claimsRequest;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (this.getOidcResponseContext().getRequestedClaims() != null && (claimsRequest = this.getOidcResponseContext().getRequestedClaims()).getIDTokenClaimsRequest() != null) {
            this.idTokenClaims = this.getOidcResponseContext().getRequestedClaims().getIDTokenClaimsRequest().getEntries();
        }
        this.idTokenHint = this.getAuthenticationRequest().getIDTokenHint();
        if (this.idTokenClaims == null && this.idTokenHint == null) {
            this.log.debug("{} No requested claims nor id token hint, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.idTokenClaims != null && !this.idTokenClaims.isEmpty()) {
            for (ClaimsSetRequest.Entry entry : this.idTokenClaims) {
                if (!"sub".equals(entry.getClaimName())) continue;
                this.log.debug("{} Setting requested sub claim value {}", (Object)this.getLogPrefix(), (Object)entry.getValueAsString());
                this.getOidcResponseContext().setRequestedSubject(entry.getValueAsString());
                return;
            }
        }
        try {
            if (this.idTokenHint != null && this.idTokenHint.getJWTClaimsSet() != null) {
                this.log.debug("{} Setting requested sub claim value {}", (Object)this.getLogPrefix(), (Object)this.idTokenHint.getJWTClaimsSet().getSubject());
                this.getOidcResponseContext().setRequestedSubject(this.idTokenHint.getJWTClaimsSet().getSubject());
            }
        }
        catch (ParseException e) {
            this.log.error("{} error parsing id token hint", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
    }
}

