/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.Nonce;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.shibboleth.idp.authn.context.SubjectContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseConsentContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestCodeChallengeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestCodeChallengeMethodLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultRequestNonceLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.OIDCAuthenticationResponseContextLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.oidc.profile.config.logic.AttributeConsentFlowEnabledPredicate;
import net.shibboleth.oidc.profile.config.navigate.AuthorizationCodeClaimsSetManipulationStrategyLookupFunction;
import net.shibboleth.oidc.profile.config.navigate.AuthzCodeLifetimeLookupFunction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetAuthorizationCodeToResponseContext
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetAuthorizationCodeToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @NonnullAfterInit
    private DataSealer dataSealer;
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, Duration> authzCodeLifetimeLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> tokenClaimsContextLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> consentContextLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> consentEnabledPredicate;
    @Nonnull
    private Function<ProfileRequestContext, String> codeChallengeLookupStrategy = new DefaultRequestCodeChallengeLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, String> codeChallengeMethodLookupStrategy = new DefaultRequestCodeChallengeMethodLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> tokenClaimsSetManipulationStrategyLookupStrategy;
    @Nullable
    private BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>> manipulationStrategy;
    @Nullable
    private SubjectContext subjectCtx;
    @Nullable
    private Duration authzCodeLifetime;
    @Nullable
    private String codeChallenge;

    public SetAuthorizationCodeToResponseContext() {
        this.tokenClaimsContextLookupStrategy = new ChildContextLookup(OIDCAuthenticationResponseTokenClaimsContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
        this.consentContextLookupStrategy = new ChildContextLookup(OIDCAuthenticationResponseConsentContext.class).compose((Function)new OIDCAuthenticationResponseContextLookupFunction());
        this.authzCodeLifetimeLookupStrategy = new AuthzCodeLifetimeLookupFunction();
        this.issuerLookupStrategy = new ResponderIdLookupFunction();
        this.consentEnabledPredicate = new AttributeConsentFlowEnabledPredicate();
        this.idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
        this.tokenClaimsSetManipulationStrategyLookupStrategy = new AuthorizationCodeClaimsSetManipulationStrategyLookupFunction();
    }

    public void setDataSealer(@Nonnull DataSealer sealer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    public void setCodeChallengeLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.codeChallengeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Code challenge lookup strategy cannot be null");
    }

    public void setCodeChallengeMethodLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.codeChallengeMethodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Code challenge method lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseTokenClaimsContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseTokenClaimsContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tokenClaimsContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseTokenClaimsContext lookup strategy cannot be null");
    }

    public void setOIDCAuthenticationResponseConsentContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationResponseConsentContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consentContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthenticationResponseConsentContext lookup strategy cannot be null");
    }

    public void setAuthzCodeLifetimeLookupStrategy(@Nonnull Function<ProfileRequestContext, Duration> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authzCodeLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authz code lifetime lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IssuerLookupStrategy lookup strategy cannot be null");
    }

    public void setConsentEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consentEnabledPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"predicate used to check if consent is enabled cannot be null");
    }

    public void setTokenClaimsSetManipulationStrategyLookupStrategy(@Nonnull Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.tokenClaimsSetManipulationStrategyLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Manipulation strategy lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.dataSealer == null) {
            throw new ComponentInitializationException("DataSealer cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.subjectCtx = (SubjectContext)profileRequestContext.getSubcontext(SubjectContext.class, false);
        if (this.subjectCtx == null) {
            this.log.warn("{} No subject context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.warn("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return false;
        }
        this.authzCodeLifetime = this.authzCodeLifetimeLookupStrategy.apply(profileRequestContext);
        if (this.authzCodeLifetime == null) {
            this.log.warn("{} No authorization code lifetime available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.codeChallenge = this.codeChallengeLookupStrategy.apply(profileRequestContext);
        if (this.codeChallenge != null && !this.codeChallenge.isEmpty()) {
            String codeChallengeMethod = this.codeChallengeMethodLookupStrategy.apply(profileRequestContext);
            this.codeChallenge = (codeChallengeMethod != null ? codeChallengeMethod : "plain") + this.codeChallenge;
        }
        this.manipulationStrategy = this.tokenClaimsSetManipulationStrategyLookupStrategy.apply(profileRequestContext);
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseContext responseCtx = this.getOidcResponseContext();
        OIDCAuthenticationResponseConsentContext consentCtx = this.consentContextLookupStrategy.apply(profileRequestContext);
        JSONArray consented = consentCtx != null ? consentCtx.getConsentedAttributes() : null;
        ClaimsSet claims = null;
        ClaimsSet claimsID = null;
        ClaimsSet claimsUI = null;
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx = this.tokenClaimsContextLookupStrategy.apply(profileRequestContext);
        if (tokenClaimsCtx != null) {
            claims = tokenClaimsCtx.getClaims();
            claimsID = tokenClaimsCtx.getIdtokenClaims();
            claimsUI = tokenClaimsCtx.getUserinfoClaims();
        }
        Instant dateExp = Instant.now().plus(this.authzCodeLifetime);
        Scope scope = responseCtx.getScope();
        AuthorizeCodeClaimsSet claimsSet = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(this.getAuthenticationRequest().getClientID()).setIssuer(this.issuerLookupStrategy.apply(profileRequestContext)).setPrincipal(this.subjectCtx.getPrincipalName()).setSubject(responseCtx.getSubject()).setIssuedAt(Instant.now()).setExpiresAt(dateExp).setAuthenticationTime(responseCtx.getAuthTime()).setRedirectURI(responseCtx.getRedirectURI()).setScope(scope != null ? scope : new Scope()).setAudience((Collection)responseCtx.getAudience()).setACR(responseCtx.getAcr()).setNonce((Nonce)new DefaultRequestNonceLookupFunction().apply(profileRequestContext)).setCodeChallenge(this.codeChallenge).setClaimsRequest(responseCtx.getRequestedClaims()).setDlClaims(claims).setDlClaimsID(claimsID).setDlClaimsUI(claimsUI).setConsentedClaims((List)consented).setConsentEnabled(Boolean.valueOf(this.consentEnabledPredicate.test(profileRequestContext))).build();
        if (this.manipulationStrategy != null) {
            this.log.debug("{} Manipulation strategy has been set, applying it to the claims set {}", (Object)this.getLogPrefix(), (Object)claimsSet.serialize());
            Map<String, Object> result = this.manipulationStrategy.apply(profileRequestContext, claimsSet.getClaimsSet().toJSONObject());
            if (result == null) {
                this.log.debug("{} Manipulation strategy returned null, leaving token claims set untouched.", (Object)this.getLogPrefix());
            } else {
                this.log.debug("{} Applying the manipulated claims into the token claims set", (Object)this.getLogPrefix());
                try {
                    claimsSet.setClaimsSet(JWTClaimsSet.parse(result));
                }
                catch (ParseException e) {
                    this.log.error("{} The resulted claims set could not be transformed into ", (Object)this.getLogPrefix(), (Object)e);
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
                    return;
                }
            }
        } else {
            this.log.debug("{} No manipulation strategy configured", (Object)this.getLogPrefix());
        }
        responseCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claimsSet);
        try {
            responseCtx.setAuthorizationCode(claimsSet.serialize(this.dataSealer));
            this.log.debug("{} Setting authz code {} as {} to response context ", new Object[]{this.getLogPrefix(), claimsSet.serialize(), responseCtx.getAuthorizationCode()});
        }
        catch (DataSealerException e) {
            this.log.error("{} Authorization Code generation failed {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToEncrypt");
        }
    }
}

