/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationResponseContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateClientSecret
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(GenerateClientSecret.class);
    @Nonnull
    private Function<MessageContext, OIDCClientRegistrationResponseContext> oidcResponseContextLookupStrategy = new ChildContextLookup(OIDCClientRegistrationResponseContext.class);
    @Nullable
    private IdentifierGenerationStrategy idGenerator;
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy = FunctionSupport.constant((Object)new SecureRandomIdentifierGenerationStrategy());
    @Nullable
    private OIDCClientRegistrationResponseContext oidcResponseCtx;
    @Nullable
    private Function<ProfileRequestContext, Duration> secretExpirationPeriodStrategy;

    public void setSecretExpirationPeriodStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.secretExpirationPeriodStrategy = strategy;
    }

    public void setOidcResponseContextLookupStrategy(@Nonnull Function<MessageContext, OIDCClientRegistrationResponseContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.oidcResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationResponseContext lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (profileRequestContext.getOutboundMessageContext() == null) {
            this.log.debug("{} No outbound message context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.oidcResponseCtx = this.oidcResponseContextLookupStrategy.apply(profileRequestContext.getOutboundMessageContext());
        if (this.oidcResponseCtx == null) {
            this.log.debug("{} No OIDC client registration response context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        Duration lifetime;
        Duration duration = lifetime = this.secretExpirationPeriodStrategy != null ? this.secretExpirationPeriodStrategy.apply(profileRequestContext) : null;
        if (lifetime == null) {
            this.log.debug("{} No secret expiration period supplied, using default (non-expiring)", (Object)this.getLogPrefix());
            lifetime = Duration.ZERO;
        }
        Instant now = Instant.now();
        Instant expiration = now.plus(lifetime);
        String clientSecret = this.idGenerator.generateIdentifier();
        this.oidcResponseCtx.setClientSecret(clientSecret);
        if (expiration.isAfter(now)) {
            this.oidcResponseCtx.setClientSecretExpiresAt(expiration);
            this.log.debug("{} Created a new client secret, expiring at {}", (Object)this.getLogPrefix(), (Object)expiration);
        } else {
            this.log.debug("{} Created a new client secret, non-expiring", (Object)this.getLogPrefix());
        }
    }
}

