/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultOIDCClientRegistrationTokenClaimsContextLookupFunction;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateClientID
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(GenerateClientID.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> oidcResponseContextLookupStrategy = new ChildContextLookup(OIDCClientRegistrationResponseContext.class).compose((Function)new OutboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, OIDCClientRegistrationTokenClaimsContext> registrationTokenContextLookupStrategy = new DefaultOIDCClientRegistrationTokenClaimsContextLookupFunction();
    @Nullable
    private RelyingPartyContext rpCtx;
    @Nullable
    private OIDCClientRegistrationResponseContext oidcResponseCtx;
    @Nullable
    private OIDCClientRegistrationTokenClaimsContext registrationTokenCtx;

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setOidcResponseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationResponseContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.oidcResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationResponseContext lookup strategy cannot be null");
    }

    public void setRegistrationTokenContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCClientRegistrationTokenClaimsContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.registrationTokenContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCClientRegistrationTokenClaimsContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (this.rpCtx == null) {
            this.log.debug("{} No relying party context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        if (this.rpCtx.getProfileConfig() == null) {
            this.log.debug("{} No profile configuration associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        if (profileRequestContext.getOutboundMessageContext() == null) {
            this.log.debug("{} No outbound message context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.oidcResponseCtx = this.oidcResponseContextLookupStrategy.apply(profileRequestContext);
        if (this.oidcResponseCtx == null) {
            this.log.debug("{} No OIDC client registration response context associated with this profile request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.registrationTokenCtx = this.registrationTokenContextLookupStrategy.apply(profileRequestContext);
        if (this.registrationTokenCtx != null && this.registrationTokenCtx.getClaimsSet() == null) {
            this.registrationTokenCtx = null;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ProfileConfiguration profileConfig = this.rpCtx.getProfileConfig();
        IdentifierGenerationStrategy idGenerator = profileConfig.getSecurityConfiguration(profileRequestContext).getIdGenerator();
        String clientId = null;
        if (this.registrationTokenCtx != null) {
            clientId = this.registrationTokenCtx.getClaimsSet().getClientId();
        }
        if (clientId != null) {
            this.log.debug("{} Using client_id supplied by access token: {}", (Object)this.getLogPrefix(), (Object)clientId);
        } else {
            clientId = idGenerator.generateIdentifier();
            this.log.debug("{} Created a new client ID: {}", (Object)this.getLogPrefix(), (Object)clientId);
        }
        this.oidcResponseCtx.setClientId(clientId);
    }
}

