/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.oidc.profile.config.navigate.TokenEndpointAuthMethodLookupFunction;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddTokenEndpointAuthMethodsToClientMetadata
extends AbstractOIDCClientMetadataPopulationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddTokenEndpointAuthMethodsToClientMetadata.class);
    @Nullable
    private Function<ProfileRequestContext, Set<ClientAuthenticationMethod>> tokenEndpointAuthMethodsLookupStrategy = new TokenEndpointAuthMethodLookupFunction();

    public void setTokenEndpointAuthMethodsLookupStrategy(@Nonnull Function<ProfileRequestContext, Set<ClientAuthenticationMethod>> strategy) {
        this.tokenEndpointAuthMethodsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Strategy to obtain enabled token endpoint authentication methods cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ClientAuthenticationMethod requestedMethod = this.getInputMetadata().getTokenEndpointAuthMethod() != null ? this.getInputMetadata().getTokenEndpointAuthMethod() : ClientAuthenticationMethod.getDefault();
        Set<ClientAuthenticationMethod> enabledMethods = this.tokenEndpointAuthMethodsLookupStrategy.apply(profileRequestContext);
        if (enabledMethods == null || !enabledMethods.contains(requestedMethod)) {
            this.log.warn("{} Non-supported token_endpoint_auth_method {}", (Object)this.getLogPrefix(), (Object)requestedMethod);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessage");
            return;
        }
        this.getOutputMetadata().setTokenEndpointAuthMethod(requestedMethod);
    }
}

