/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.interfaces.ECPrivateKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCSigningResponseAction;
import net.shibboleth.oidc.security.credential.JWKCredential;
import net.shibboleth.oidc.security.impl.CredentialConversionUtil;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignJWTAction
extends AbstractOIDCSigningResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AbstractSignJWTAction.class);
    @Nullable
    @NotEmpty
    private String typeHeader;
    @Nullable
    private Credential credential;

    public void setTypeHeader(@Nullable @NotEmpty String type) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.typeHeader = StringSupport.trimOrNull((String)type);
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.credential = this.getSignatureSigningParameters().getSigningCredential();
        return true;
    }

    private JWSSigner getSigner(Algorithm jwsAlgorithm) throws JOSEException {
        if (JWSAlgorithm.Family.EC.contains((Object)jwsAlgorithm)) {
            return new ECDSASigner((ECPrivateKey)this.credential.getPrivateKey());
        }
        if (JWSAlgorithm.Family.RSA.contains((Object)jwsAlgorithm)) {
            return new RSASSASigner(this.credential.getPrivateKey());
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)jwsAlgorithm)) {
            return new MACSigner(this.credential.getSecretKey());
        }
        throw new JOSEException("Unsupported algorithm " + jwsAlgorithm.getName());
    }

    protected JWSAlgorithm resolveAlgorithm() {
        JWSAlgorithm algorithm = new JWSAlgorithm(this.getSignatureSigningParameters().getSignatureAlgorithm());
        if (this.credential instanceof JWKCredential && !algorithm.equals((Object)((JWKCredential)this.credential).getAlgorithm())) {
            this.log.debug("{} Signature signing algorithm {} differs from JWK algorithm {}", new Object[]{this.getLogPrefix(), algorithm.getName(), ((JWKCredential)this.credential).getAlgorithm()});
        }
        this.log.debug("{} Algorithm resolved {}", (Object)this.getLogPrefix(), (Object)algorithm.getName());
        return algorithm;
    }

    protected abstract void setSignedJWT(@Nullable SignedJWT var1);

    @Nonnull
    protected abstract JWTClaimsSet getClaimsSetToSign();

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        SignedJWT jwt = null;
        JWTClaimsSet jwtClaimSet = this.getClaimsSetToSign();
        if (jwtClaimSet == null) {
            this.log.debug("Claim set is null, nothing to do");
            return;
        }
        try {
            JWSAlgorithm jwsAlgorithm = this.resolveAlgorithm();
            JWSSigner signer = this.getSigner((Algorithm)jwsAlgorithm);
            JWSHeader.Builder headerBuilder = new JWSHeader.Builder(new JWSAlgorithm(jwsAlgorithm.getName())).keyID(CredentialConversionUtil.resolveKid((Credential)this.credential));
            if (this.typeHeader != null) {
                headerBuilder.type(new JOSEObjectType(this.typeHeader));
            }
            jwt = new SignedJWT(headerBuilder.build(), jwtClaimSet);
            jwt.sign(signer);
        }
        catch (JOSEException e) {
            this.log.error("{} Error signing claim set: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"UnableToSign");
            return;
        }
        this.setSignedJWT(jwt);
    }
}

