/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Duration;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.oauth2.messaging.context.OAuth2TokenMgmtResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultChainRevocationLifetimeLookupStrategy;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultRootTokenIdentifierLookupStrategy;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultTokenRevocationLifetimeLookupStrategy;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.profile.config.navigate.RevocationMethodLookupFunction;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2TokenRevocationConfiguration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.RevocationCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokeToken
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(RevokeToken.class);
    @NonnullAfterInit
    private RevocationCache revocationCache;
    @Nonnull
    private Function<ProfileRequestContext, OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod> revocationMethodLookupStrategy = new RevocationMethodLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, Duration> chainRevocationLifetimeLookupStrategy = new DefaultChainRevocationLifetimeLookupStrategy();
    @Nonnull
    private Function<JWTClaimsSet, Duration> tokenRevocationLifetimeLookupStrategy = new DefaultTokenRevocationLifetimeLookupStrategy();
    @Nonnull
    private Function<JWTClaimsSet, String> rootTokenIdentifierLookupStrategy = new DefaultRootTokenIdentifierLookupStrategy();
    private OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod revocationMethod;
    private Duration revocationLifetime;
    private JWTClaimsSet claimsSet;

    public void setRevocationCache(@Nonnull RevocationCache cache) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.revocationCache = (RevocationCache)Constraint.isNotNull((Object)cache, (String)"RevocationCache cannot be null");
    }

    public void setRevocationMethodLookupStrategy(@Nonnull Function<ProfileRequestContext, OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod> strategy) {
        this.revocationMethodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setChainRevocationLifetimeLookupStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.chainRevocationLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setTokenRevocationLifetimeLookupStrategy(@Nullable Function<JWTClaimsSet, Duration> strategy) {
        this.tokenRevocationLifetimeLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    public void setRootTokenIdentifierLookupStrategy(@Nullable Function<JWTClaimsSet, String> strategy) {
        this.rootTokenIdentifierLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.revocationCache == null) {
            throw new ComponentInitializationException("RevocationCache cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.revocationMethod = this.revocationMethodLookupStrategy.apply(profileRequestContext);
        if (this.revocationMethod == null) {
            this.log.error("{} Unable to obtain revocation method to use", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        OAuth2TokenMgmtResponseContext ctx = (OAuth2TokenMgmtResponseContext)profileRequestContext.getOutboundMessageContext().getSubcontext(OAuth2TokenMgmtResponseContext.class);
        if (ctx == null || ctx.getTokenClaimsSet() == null) {
            this.log.debug("{} No token validated for revocation, assumed to be invalid", (Object)this.getLogPrefix());
            return false;
        }
        this.claimsSet = ctx.getTokenClaimsSet();
        if (OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.CHAIN.equals((Object)this.revocationMethod)) {
            this.revocationLifetime = this.chainRevocationLifetimeLookupStrategy.apply(profileRequestContext);
        } else if (OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.TOKEN.equals((Object)this.revocationMethod)) {
            this.revocationLifetime = this.tokenRevocationLifetimeLookupStrategy.apply(this.claimsSet);
        }
        if (this.revocationLifetime == null || Duration.ZERO.equals(this.revocationLifetime)) {
            this.log.error("{} Unable to obtain revocation lifetime to use", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String jti = this.claimsSet.getJWTID();
        if (jti == null) {
            this.log.error("{} No ID found in token claims set (this should be impossible)", (Object)this.getLogPrefix());
            return;
        }
        if (OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.CHAIN.equals((Object)this.revocationMethod)) {
            String idToRevoke;
            String rootJti = this.rootTokenIdentifierLookupStrategy.apply(this.claimsSet);
            if (StringSupport.trimOrNull((String)rootJti) == null) {
                this.log.warn("{} No root token identifier returned, using JWT id", (Object)this.getLogPrefix());
                idToRevoke = jti;
            } else {
                idToRevoke = rootJti;
            }
            if (this.revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, idToRevoke, this.revocationLifetime)) {
                this.log.debug("{} Revoked all tokens based on ID '{}'", (Object)this.getLogPrefix(), (Object)idToRevoke);
            } else {
                this.log.warn("{} Failed to revoke tokens based on ID '{}'", (Object)this.getLogPrefix(), (Object)idToRevoke);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RevocationFailed");
            }
        } else if (OAuth2TokenRevocationConfiguration.OAuth2TokenRevocationMethod.TOKEN.equals((Object)this.revocationMethod)) {
            if (this.revocationCache.revoke(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, jti, this.revocationLifetime)) {
                this.log.debug("{} Revoked the single token with ID '{}'", (Object)this.getLogPrefix(), (Object)jti);
            } else {
                this.log.warn("{} Failed to revoke the single token with ID '{}'", (Object)this.getLogPrefix(), (Object)jti);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RevocationFailed");
            }
        } else {
            this.log.error("{} Unrecognized revocation method: {}", (Object)this.getLogPrefix(), (Object)this.revocationMethod);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"RevocationFailed");
        }
    }
}

