/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.MetadataValueResolver;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayMetadataValueResolver
extends AbstractIdentifiableInitializableComponent
implements MetadataValueResolver {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ArrayMetadataValueResolver.class);
    private String objectName = null;
    private List<MetadataValueResolver> embeddedResolvers;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.embeddedResolvers == null) {
            throw new ComponentInitializationException("The list of embedded resolvers cannot be null");
        }
    }

    public void setEmbeddedResolvers(List<MetadataValueResolver> resolvers) {
        this.embeddedResolvers = (List)Constraint.isNotNull(resolvers, (String)"The list of embedded resolvers cannot be null");
    }

    public void setObjectName(String name) {
        this.objectName = StringSupport.trimOrNull((String)name);
    }

    public Iterable<Object> resolve(@Nullable ProfileRequestContext profileRequestContext) throws ResolverException {
        ArrayList<Object> result = new ArrayList<Object>();
        for (MetadataValueResolver resolver : this.embeddedResolvers) {
            this.log.debug("Adding the result from the resolver {}", (Object)resolver.getId());
            result.add(resolver.resolveSingle((Object)profileRequestContext));
        }
        return result;
    }

    public Object resolveSingle(@Nullable ProfileRequestContext profileRequestContext) throws ResolverException {
        JSONArray jsonArray = new JSONArray();
        Iterator<Object> iterator = this.resolve(profileRequestContext).iterator();
        while (iterator.hasNext()) {
            jsonArray.add(iterator.next());
        }
        if (this.objectName == null) {
            return jsonArray;
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)this.objectName, (Object)jsonArray);
        return jsonObject;
    }
}

