/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.decoding.impl;

import com.google.common.base.MoreObjects;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.http.ServletUtils;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.RequestUtil;
import net.shibboleth.idp.plugin.oidc.op.oauth2.decoding.impl.BaseOAuth2RequestDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCTokenRequestDecoder
extends BaseOAuth2RequestDecoder<TokenRequest> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCTokenRequestDecoder.class);

    @Override
    protected TokenRequest parseMessage() throws MessageDecodingException {
        try {
            HTTPRequest httpReq = ServletUtils.createHTTPRequest((HttpServletRequest)this.getHttpServletRequest());
            this.getProtocolMessageLog().trace("Inbound request {}", (Object)RequestUtil.toString(httpReq));
            return TokenRequest.parse((HTTPRequest)httpReq);
        }
        catch (ParseException | IOException e) {
            this.log.error("Unable to decode inbound request: {}", (Object)e.getMessage());
            throw new MessageDecodingException((Exception)e);
        }
    }

    @Override
    protected String getMessageToLog(@Nullable TokenRequest message) {
        return message == null ? null : MoreObjects.toStringHelper((Object)((Object)this)).omitNullValues().add("authorizationGrant", (Object)RequestUtil.getAuthorizationGrantLog(message.getAuthorizationGrant())).add("clientAuthentication", (Object)RequestUtil.getClientAuthenticationLog(message.getClientAuthentication())).add("clientId", (Object)message.getClientID()).add("customParameters", (Object)message.getCustomParameters()).add("endpointURI", (Object)message.getEndpointURI()).add("existingGrant", (Object)RequestUtil.getRefreshTokenLog(message.getExistingGrant())).add("resources", (Object)message.getResources()).add("scope", (Object)message.getScope()).toString();
    }
}

