/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl;

import com.nimbusds.jose.JWSAlgorithm;
import java.util.function.Function;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl.AddUserInfoShell;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.ResponderIdLookupFunction;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddUserInfoShellTest
extends BaseOIDCResponseActionTest {
    private AddUserInfoShell action;

    @BeforeMethod
    public void init() throws ComponentInitializationException {
        this.action = new AddUserInfoShell();
        this.action.setIssuerLookupStrategy((Function)new ResponderIdLookupFunction());
        this.action.initialize();
    }

    @Test
    public void testSuccess() {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)this.respCtx.getUserInfo().getClaim("sub"), (Object)this.subject);
        Assert.assertNull((Object)this.respCtx.getUserInfo().getClaim("aud"));
        Assert.assertNull((Object)this.respCtx.getUserInfo().getIssuer());
    }

    @Test
    public void testSuccessForSigned() {
        this.metadataCtx.getClientInformation().getOIDCMetadata().setUserInfoJWSAlg(JWSAlgorithm.HS256);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)this.respCtx.getUserInfo().getClaim("sub"), (Object)this.subject);
        Assert.assertNotNull((Object)this.respCtx.getUserInfo().getClaim("sub"));
        Assert.assertNotNull((Object)this.respCtx.getUserInfo().getIssuer());
    }

    @Test
    public void testFailNoRPContext() {
        this.profileRequestCtx.removeSubcontext(RelyingPartyContext.class);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRelyingPartyContext");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullIssuerLookupStrategy() {
        this.action = new AddUserInfoShell();
        this.action.setIssuerLookupStrategy(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullRelyingPartyContextLookupStrategy() {
        this.action = new AddUserInfoShell();
        this.action.setRelyingPartyContextLookupStrategy(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNulltUserInfoSigningAlgLookupStrategy() {
        this.action = new AddUserInfoShell();
        this.action.setUserInfoSigningAlgLookupStrategy(null);
    }
}

