/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl;

import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.UserInfoRequest;
import java.net.URI;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl.AbstractOIDCUserInfoResponseAction;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AbstractOIDCUserInfoResponseActionTest {
    private MockOIDCUserInfoResponseAction action;
    private RequestContext requestCtx;
    private OIDCMetadataContext oIDCMetadataContext;
    private OIDCAuthenticationResponseContext oIDCAuthenticationResponseContext;
    private ProfileRequestContext prc;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.action = new MockOIDCUserInfoResponseAction();
        this.oIDCMetadataContext = new OIDCMetadataContext();
        this.oIDCAuthenticationResponseContext = new OIDCAuthenticationResponseContext();
        URI callback = new URI("https://client.com/callback");
        UserInfoRequest req = new UserInfoRequest(callback, (AccessToken)new BearerAccessToken());
        this.requestCtx = new RequestContextBuilder().setInboundMessage((Object)req).buildRequestContext();
        MessageContext msgCtx = new MessageContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        this.prc.getInboundMessageContext().addSubcontext((BaseContext)this.oIDCMetadataContext);
        msgCtx.addSubcontext((BaseContext)this.oIDCAuthenticationResponseContext);
        this.prc.setOutboundMessageContext(msgCtx);
        this.action.initialize();
    }

    @Test
    public void testNoOutboundMessageContext() throws Exception {
        this.prc.setOutboundMessageContext(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testNoOidcResponseContext() throws Exception {
        this.prc.getOutboundMessageContext().removeSubcontext((BaseContext)this.oIDCAuthenticationResponseContext);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testNoMetadataContext() throws Exception {
        this.prc.getInboundMessageContext().removeSubcontext((BaseContext)this.oIDCMetadataContext);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testSuccess() throws Exception {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    class MockOIDCUserInfoResponseAction
    extends AbstractOIDCUserInfoResponseAction {
        MockOIDCUserInfoResponseAction() {
        }
    }
}

