/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.ValidateResponseType;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateResponseTypeTest
extends BaseOIDCResponseActionTest {
    private ValidateResponseType action;
    private OIDCClientMetadata metaData;

    @BeforeMethod
    private void init() throws ComponentInitializationException, URISyntaxException, ParseException {
        this.action = new ValidateResponseType();
        this.action.initialize();
        OIDCMetadataContext oidcCtx = (OIDCMetadataContext)this.profileRequestCtx.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class, true);
        this.metaData = new OIDCClientMetadata();
        HashSet<ResponseType> responseTypes = new HashSet<ResponseType>();
        responseTypes.add(ResponseType.parse((String)"code"));
        responseTypes.add(ResponseType.parse((String)"id_token token"));
        this.metaData.setResponseTypes(responseTypes);
        this.metaData.setRedirectionURI(new URI("https://notmatching.org"));
        OIDCClientInformation information = new OIDCClientInformation(new ClientID("test"), null, this.metaData, null, null, null);
        oidcCtx.setClientInformation(information);
    }

    @Test
    public void testSuccess() throws ComponentInitializationException {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testFailure() throws ComponentInitializationException, ParseException {
        HashSet<ResponseType> responseTypes = new HashSet<ResponseType>();
        responseTypes.add(ResponseType.parse((String)"code"));
        this.metaData.setResponseTypes(responseTypes);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidResponseType");
    }
}

