/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.SubjectType;
import java.net.URI;
import java.net.URISyntaxException;
import net.shibboleth.idp.attribute.resolver.context.AttributeResolutionContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SetSectorIdentifierForAttributeResolution;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SetSectorIdentifierForAttributeResolutionTest
extends BaseOIDCResponseActionTest {
    private SetSectorIdentifierForAttributeResolution action;

    @BeforeMethod
    private void init() throws ComponentInitializationException, URISyntaxException {
        this.action = new SetSectorIdentifierForAttributeResolution();
        this.action.initialize();
        this.metadataCtx.getClientInformation().getOIDCMetadata().setSubjectType(SubjectType.PUBLIC);
        this.metadataCtx.getClientInformation().getOIDCMetadata().setRedirectionURI(new URI("http://example.com"));
    }

    @Test
    public void testSuccessPublic() throws ComponentInitializationException {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AttributeResolutionContext attribCtx = (AttributeResolutionContext)this.profileRequestCtx.getSubcontext(AttributeResolutionContext.class, true);
        Assert.assertEquals((String)attribCtx.getAttributeRecipientGroupID(), (String)"public");
    }

    @Test
    public void testSuccessPairwise() throws ComponentInitializationException {
        this.metadataCtx.getClientInformation().getOIDCMetadata().setSubjectType(SubjectType.PAIRWISE);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        AttributeResolutionContext attribCtx = (AttributeResolutionContext)this.profileRequestCtx.getSubcontext(AttributeResolutionContext.class, true);
        Assert.assertEquals((String)attribCtx.getAttributeRecipientGroupID(), (String)"example.com");
    }

    @Test
    public void testFailPairwiseNoSectorIdentifier() throws ComponentInitializationException {
        this.metadataCtx.getClientInformation().getOIDCMetadata().setSubjectType(SubjectType.PAIRWISE);
        this.metadataCtx.getClientInformation().getOIDCMetadata().setRedirectionURI(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"MissingRedirectionURIs");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullStrategySectorIdentifier() {
        this.action = new SetSectorIdentifierForAttributeResolution();
        this.action.setSectorIdentifierLookupStrategy(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullStrategySubjectType() {
        this.action = new SetSectorIdentifierForAttributeResolution();
        this.action.setSubjectTypeLookupStrategy(null);
    }
}

