/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.google.common.net.UrlEscapers;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SetRequestObjectToResponseContext;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import net.shibboleth.utilities.java.support.test.repository.RepositorySupport;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SetRequestObjectToResponseContextTest
extends BaseOIDCResponseActionTest {
    private SetRequestObjectToResponseContext action;

    @Override
    @BeforeMethod
    public void setUp() throws Exception {
        super.setUp();
        this.action = new SetRequestObjectToResponseContext();
        HttpClientBuilder builder = new HttpClientBuilder();
        builder.setTLSSocketFactory(HttpClientSupport.buildNoTrustTLSSocketFactory());
        this.action.setHttpClient(builder.buildClient());
        this.action.initialize();
    }

    @Test
    public void testNothingToDo() {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testRequestObject() throws ParseException {
        JWTClaimsSet ro = new JWTClaimsSet.Builder().claim("redirect_uri", (Object)"https://rp.example.org/redirect_uri").build();
        PlainJWT requestObject = new PlainJWT(ro);
        this.setAuthenticationRequest(AuthenticationRequest.parse((String)("client_id=mockClientId&request=" + requestObject.serialize())));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getRequestObject());
    }

    @Test
    public void testInvalidRequestURI() throws ParseException, URISyntaxException {
        this.metadataCtx.getClientInformation().getOIDCMetadata().setRequestObjectURIs(Set.of(new URI("https://localhost/foobar")));
        this.setAuthenticationRequest(AuthenticationRequest.parse((String)"client_id=mockClientId&request_uri=http://localhost/foo"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidRequestUri");
    }

    @Test
    public void testRequestURI() throws URISyntaxException, ParseException {
        String uri = RepositorySupport.buildHTTPSResourceURL((String)"java-idp-oidc", (String)"idp-oidc-extension-impl/src/test/resources/net/shibboleth/idp/oidc/profile/impl/oidc-authreq.json");
        this.metadataCtx.getClientInformation().getOIDCMetadata().setRequestObjectURIs(Set.of(new URI(uri)));
        this.setAuthenticationRequest(AuthenticationRequest.parse((String)("client_id=" + this.clientId + "&request_uri=" + UrlEscapers.urlFormParameterEscaper().escape(uri))));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getRequestObject());
        Assert.assertTrue((boolean)(this.respCtx.getRequestObject() instanceof SignedJWT));
    }
}

