/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SetRefreshTokenToResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.DefaultTokenRevocationLifetimeLookupStrategy;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.RevocationCache;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SetRefreshTokenToResponseContextTest
extends BaseOIDCResponseActionTest {
    private SetRefreshTokenToResponseContext action;
    RevocationCache revocationCache;
    private boolean enforceRotation;

    @BeforeMethod
    private void init() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException {
        Scope scope = new Scope();
        scope.add((Object)OIDCScopeValue.OFFLINE_ACCESS);
        this.respCtx.setScope(scope);
        TokenClaimsSet claims = new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).build();
        this.respCtx.setAuthorizationGrantClaimsSet(claims);
        MemoryStorageService storageService = new MemoryStorageService();
        storageService.setId("id");
        storageService.initialize();
        this.revocationCache = new RevocationCache();
        this.revocationCache.setStorage((StorageService)storageService);
        this.enforceRotation = false;
        this.action = this.initAction(null);
    }

    protected SetRefreshTokenToResponseContext initAction(Function<ProfileRequestContext, BiFunction<ProfileRequestContext, Map<String, Object>, Map<String, Object>>> manipulationStrategy) throws ComponentInitializationException, NoSuchAlgorithmException {
        SetRefreshTokenToResponseContext action = new SetRefreshTokenToResponseContext(this.getDataSealer());
        action.setRevocationCache(this.revocationCache);
        if (manipulationStrategy != null) {
            action.setTokenClaimsSetManipulationStrategyLookupStrategy(manipulationStrategy);
        }
        DefaultTokenRevocationLifetimeLookupStrategy revocationLifetimeLookup = new DefaultTokenRevocationLifetimeLookupStrategy();
        revocationLifetimeLookup.setClockSkew(Duration.ZERO);
        action.setTokenRevocationLifetimeLookupStrategy((Function)revocationLifetimeLookup);
        action.setEnforceRefreshTokenRotationCondition(prc -> this.enforceRotation);
        action.initialize();
        return action;
    }

    @Test
    public void testSuccessViaCode() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, ParseException, DataSealerException {
        String jit = this.respCtx.getAuthorizationGrantClaimsSet().getID();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getRefreshToken());
        RefreshTokenClaimsSet rt = RefreshTokenClaimsSet.parse((String)this.respCtx.getRefreshToken().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)rt);
        Assert.assertNotEquals((Object)rt.getID(), (Object)jit);
        Assert.assertEquals((String)rt.getRootTokenIdentifier(), (String)jit);
    }

    @Test
    public void testSuccessViaCodeWithCustomClaim() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, ParseException, DataSealerException {
        String jit = this.respCtx.getAuthorizationGrantClaimsSet().getID();
        this.action = this.initAction(prc -> (prc2, map) -> SetRefreshTokenToResponseContextTest.addEntryToMap(map, "custom_claim", "custom_value"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getRefreshToken());
        RefreshTokenClaimsSet rt = RefreshTokenClaimsSet.parse((String)this.respCtx.getRefreshToken().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)rt);
        Assert.assertNotEquals((Object)rt.getID(), (Object)jit);
        Assert.assertEquals((String)rt.getRootTokenIdentifier(), (String)jit);
        Assert.assertNotNull((Object)rt.getClaimsSet().getClaim("custom_claim"));
        Assert.assertEquals((String)rt.getClaimsSet().getStringClaim("custom_claim"), (String)"custom_value");
    }

    @Test
    public void testSuccessViaRefresh() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, ParseException, DataSealerException {
        String rootTokenId = new SecureRandomIdentifierGenerationStrategy().generateIdentifier();
        TokenClaimsSet claims = new RefreshTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).setRootTokenIdentifier(rootTokenId).build();
        String jit = claims.getID();
        this.respCtx.setAuthorizationGrantClaimsSet(claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getRefreshToken());
        RefreshTokenClaimsSet rt = RefreshTokenClaimsSet.parse((String)this.respCtx.getRefreshToken().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)rt);
        Assert.assertNotEquals((Object)rt.getID(), (Object)jit);
        Assert.assertEquals((String)rt.getRootTokenIdentifier(), (String)rootTokenId);
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, jit));
    }

    @Test
    public void testSuccessViaRefreshWithCustomClaim() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, ParseException, DataSealerException {
        String rootTokenId = new SecureRandomIdentifierGenerationStrategy().generateIdentifier();
        TokenClaimsSet claims = new RefreshTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).setRootTokenIdentifier(rootTokenId).build();
        String jit = claims.getID();
        this.respCtx.setAuthorizationGrantClaimsSet(claims);
        this.action = this.initAction(prc -> (prc2, map) -> SetRefreshTokenToResponseContextTest.addEntryToMap(map, "custom_claim", "custom_value"));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getRefreshToken());
        RefreshTokenClaimsSet rt = RefreshTokenClaimsSet.parse((String)this.respCtx.getRefreshToken().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)rt);
        Assert.assertNotEquals((Object)rt.getID(), (Object)jit);
        Assert.assertEquals((String)rt.getRootTokenIdentifier(), (String)rootTokenId);
        Assert.assertFalse((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, jit));
        Assert.assertNotNull((Object)rt.getClaimsSet().getClaim("custom_claim"));
        Assert.assertEquals((String)rt.getClaimsSet().getStringClaim("custom_claim"), (String)"custom_value");
    }

    @Test
    public void testSuccessViaRefreshRotationEnforced() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, ParseException, DataSealerException {
        String rootTokenId = new SecureRandomIdentifierGenerationStrategy().generateIdentifier();
        TokenClaimsSet claims = new RefreshTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now().plus(Duration.ofHours(1L))).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).setRootTokenIdentifier(rootTokenId).build();
        String jit = claims.getID();
        this.respCtx.setAuthorizationGrantClaimsSet(claims);
        this.enforceRotation = true;
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getRefreshToken());
        RefreshTokenClaimsSet rt = RefreshTokenClaimsSet.parse((String)this.respCtx.getRefreshToken().getValue(), (DataSealer)this.getDataSealer());
        Assert.assertNotNull((Object)rt);
        Assert.assertNotEquals((Object)rt.getID(), (Object)jit);
        Assert.assertEquals((String)rt.getRootTokenIdentifier(), (String)rootTokenId);
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, jit));
    }

    @Test
    public void testFailWithExpiredRefreshRotationEnforced() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, ParseException, DataSealerException {
        String rootTokenId = new SecureRandomIdentifierGenerationStrategy().generateIdentifier();
        TokenClaimsSet claims = new RefreshTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setACR(new ACR("0")).setRootTokenIdentifier(rootTokenId).build();
        String jit = claims.getID();
        this.respCtx.setAuthorizationGrantClaimsSet(claims);
        this.enforceRotation = true;
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
    }

    @Test
    public void testNoToken() throws ComponentInitializationException, NoSuchAlgorithmException, URISyntaxException, ParseException, DataSealerException {
        this.respCtx.setScope(new Scope());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getRefreshToken());
    }

    @Test
    public void testFailNoRPCtx() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        this.profileRequestCtx.removeSubcontext(RelyingPartyContext.class);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
    }

    @Test
    public void testFailNoProfileConf() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        RelyingPartyContext rpCtx = (RelyingPartyContext)this.profileRequestCtx.getSubcontext(RelyingPartyContext.class, false);
        rpCtx.setProfileConfig(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileConfiguration");
    }

    @Test
    public void testFailTokenNotCodeOrRefresh() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        TokenClaimsSet claims = new AccessTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).build();
        this.respCtx.setAuthorizationGrantClaimsSet(claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
    }

    @Test
    public void testFailNoToken() throws NoSuchAlgorithmException, ComponentInitializationException, URISyntaxException {
        this.respCtx.setAuthorizationGrantClaimsSet(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
    }
}

