/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import net.minidev.json.JSONArray;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseConsentContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SetConsentFromTokenToResponseContext;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SetConsentFromTokenToResponseContextTest
extends BaseOIDCResponseActionTest {
    private SetConsentFromTokenToResponseContext action;

    @BeforeMethod
    private void init() throws ComponentInitializationException {
        this.action = new SetConsentFromTokenToResponseContext();
        this.action.initialize();
    }

    @Test
    public void testSuccessNoConsent() {
        Event event = this.action.execute(this.requestCtx);
        this.respCtx.removeSubcontext(OIDCAuthenticationResponseConsentContext.class);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getSubcontext(OIDCAuthenticationResponseConsentContext.class, false));
    }

    @Test
    public void testSuccess() throws URISyntaxException {
        JSONArray consentedClaims = new JSONArray();
        consentedClaims.add((Object)"1");
        TokenClaimsSet claims = new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject(this.subject).setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setConsentedClaims((List)consentedClaims).build();
        this.respCtx.setAuthorizationGrantClaimsSet(claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        OIDCAuthenticationResponseConsentContext ctx = (OIDCAuthenticationResponseConsentContext)this.respCtx.getSubcontext(OIDCAuthenticationResponseConsentContext.class, false);
        Assert.assertNotNull((Object)ctx);
        Assert.assertEquals((Collection)ctx.getConsentedAttributes(), (Collection)consentedClaims);
    }
}

