/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import net.shibboleth.idp.plugin.oidc.op.profile.impl.InitializeUnverifiedRelyingPartyContext;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class InitializeUnverifiedRelyingPartyContextTest {
    private InitializeUnverifiedRelyingPartyContext action;
    private RequestContext requestCtx;
    private ProfileRequestContext prc;

    @BeforeMethod
    public void init() throws ComponentInitializationException {
        this.action = new InitializeUnverifiedRelyingPartyContext();
        this.action.initialize();
        this.requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
    }

    @Test
    public void testSuccessUnverified() {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertFalse((boolean)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).isVerified());
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testFailsNullRelyingPartyContextCreationStrategy() {
        this.action = new InitializeUnverifiedRelyingPartyContext();
        this.action.setRelyingPartyContextCreationStrategy(null);
    }
}

