/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.TokenResponse;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.FormOutboundTokenResponseMessage;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.MessageContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FormOutboundTokenResponseMessageTest
extends BaseOIDCResponseActionTest {
    private FormOutboundTokenResponseMessage action;

    @BeforeMethod
    public void init() throws ComponentInitializationException, URISyntaxException, ParseException, JOSEException {
        this.action = new FormOutboundTokenResponseMessage();
        this.respCtx.setAccessToken("access_token", Duration.ofSeconds(50L));
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        this.signIdTokenInResponseContext();
        this.action.initialize();
    }

    @Test
    public void testOIDCSuccess() throws ComponentInitializationException, URISyntaxException, ParseException, JOSEException {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)(((MessageContext)this.respCtx.getParent()).getMessage() instanceof TokenResponse));
    }

    @Test
    public void testOAuthSuccess() throws ComponentInitializationException, URISyntaxException, ParseException, JOSEException {
        this.respCtx.setProcessedToken(null);
        Event event = this.action.execute(this.requestCtx);
        Assert.assertTrue((boolean)(((MessageContext)this.respCtx.getParent()).getMessage() instanceof TokenResponse));
    }

    @Test
    public void testFailNoAccessToken() throws ComponentInitializationException, URISyntaxException, ParseException, JOSEException {
        this.respCtx.setAccessToken(null, Duration.ZERO);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidProfileContext");
    }
}

