/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.idp.plugin.oidc.op.messaging.JSONSuccessResponse;
import net.shibboleth.idp.plugin.oidc.op.metadata.impl.DynamicFilesystemProviderMetadataResolver;
import net.shibboleth.idp.plugin.oidc.op.metadata.impl.FilesystemProviderMetadataResolver;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.MetadataValueResolver;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.ProviderMetadataResolver;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.FormOutboundDiscoveryResponse;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.mockito.Mockito;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FormOutboundDiscoveryResponseTest {
    protected FormOutboundDiscoveryResponse action;
    protected RequestContext requestCtx;
    protected ProfileRequestContext profileRequestCtx;
    protected Resource opfile;
    protected String dynamicClaim;
    protected String dynamicClaimValue;

    @BeforeMethod
    protected void setUpContext() throws ComponentInitializationException {
        this.action = this.buildAction();
        this.requestCtx = new RequestContextBuilder().buildRequestContext();
        this.profileRequestCtx = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
        this.opfile = new ClassPathResource("/net/shibboleth/idp/oidc/metadata/impl/openid-configuration.json");
        this.dynamicClaim = "dynamicClaimName";
        this.dynamicClaimValue = "dynamicClaimValue";
    }

    protected FormOutboundDiscoveryResponse buildAction() {
        this.action = new FormOutboundDiscoveryResponse();
        this.action.setHttpServletRequest((HttpServletRequest)new MockHttpServletRequest());
        this.action.setHttpServletResponse((HttpServletResponse)new MockHttpServletResponse());
        return this.action;
    }

    protected ProviderMetadataResolver initMetadataResolver() throws Exception {
        FilesystemProviderMetadataResolver resolver = new FilesystemProviderMetadataResolver(this.opfile);
        resolver.setId("mockStaticResolver");
        resolver.initialize();
        return resolver;
    }

    @Test
    public void testStatic() throws Exception {
        this.action.setMetadataResolver(this.initMetadataResolver());
        this.action.initialize();
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        Assert.assertTrue((boolean)(this.profileRequestCtx.getOutboundMessageContext().getMessage() instanceof JSONSuccessResponse));
        JSONSuccessResponse resp = (JSONSuccessResponse)this.profileRequestCtx.getOutboundMessageContext().getMessage();
        Assert.assertTrue((boolean)resp.indicatesSuccess());
        OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((String)resp.toHTTPResponse().getContent());
        this.assertFileContents(metadata);
        Assert.assertNull((Object)metadata.getCustomParameter(this.dynamicClaim));
    }

    @Test
    public void testDynamic() throws Exception {
        HashMap<String, MetadataValueResolver> map = new HashMap<String, MetadataValueResolver>();
        map.put(this.dynamicClaim, this.initMockResolver(this.dynamicClaimValue));
        this.action.setMetadataResolver(this.initMetadataResolver(map));
        this.action.initialize();
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        JSONSuccessResponse resp = (JSONSuccessResponse)this.profileRequestCtx.getOutboundMessageContext().getMessage();
        OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((String)resp.toHTTPResponse().getContent());
        this.assertFileContents(metadata);
        Assert.assertNotNull((Object)metadata.getCustomParameter(this.dynamicClaim));
        Assert.assertEquals((Object)metadata.getCustomParameter(this.dynamicClaim), (Object)this.dynamicClaimValue);
    }

    protected void assertFileContents(OIDCProviderMetadata metadata) throws ParseException {
        Assert.assertNotNull((Object)metadata.getIssuer());
        Assert.assertEquals((String)metadata.getIssuer().getValue(), (String)"http://idp.example.org");
        Assert.assertNotNull((Object)metadata.getAuthorizationEndpointURI());
        Assert.assertEquals((String)metadata.getAuthorizationEndpointURI().toString(), (String)"https://op.example.org/idp/profile/oidc/authorize");
        Assert.assertNotNull((Object)metadata.getRegistrationEndpointURI());
        Assert.assertEquals((String)metadata.getRegistrationEndpointURI().toString(), (String)"https://op.example.org/idp/profile/oidc/register");
        Assert.assertNotNull((Object)metadata.getJWKSetURI());
        Assert.assertEquals((String)metadata.getJWKSetURI().toString(), (String)"https://op.example.org/oidc/keyset.jwk");
        Assert.assertEquals((Collection)metadata.getResponseTypes(), Arrays.asList(ResponseType.parse((String)"id_token")));
        Assert.assertEquals((Collection)metadata.getSubjectTypes(), Arrays.asList(SubjectType.PUBLIC, SubjectType.PAIRWISE));
        Assert.assertEquals((Collection)metadata.getGrantTypes(), Arrays.asList(GrantType.IMPLICIT));
        Assert.assertEquals((Collection)metadata.getIDTokenJWSAlgs(), Arrays.asList(JWSAlgorithm.RS256));
        Assert.assertFalse((boolean)metadata.supportsRequestURIParam());
        Assert.assertFalse((boolean)metadata.supportsRequestURIParam());
        Assert.assertFalse((boolean)metadata.requiresRequestURIRegistration());
        Assert.assertEquals((Collection)metadata.getScopes(), Arrays.asList(new Scope.Value("openid"), new Scope.Value("profile"), new Scope.Value("email"), new Scope.Value("address"), new Scope.Value("phone"), new Scope.Value("info")));
        Assert.assertEquals((Collection)metadata.getClaims(), Arrays.asList("aud", "acr", "exp", "iat", "iss", "sub", "eduPersonPrincipalName", "eduPersonAffiliation", "mail"));
    }

    protected ProviderMetadataResolver initMetadataResolver(Map<String, MetadataValueResolver> map) throws Exception {
        DynamicFilesystemProviderMetadataResolver resolver = new DynamicFilesystemProviderMetadataResolver(this.opfile);
        resolver.setDynamicValueResolvers(map);
        resolver.setId("mockDynamicResolver");
        resolver.initialize();
        return resolver;
    }

    protected MetadataValueResolver initMockResolver(Object value) throws Exception {
        MetadataValueResolver resolver = (MetadataValueResolver)Mockito.mock(MetadataValueResolver.class);
        Mockito.when((Object)resolver.resolve((Object)((ProfileRequestContext)Mockito.any()))).thenReturn(Arrays.asList(value));
        Mockito.when((Object)resolver.resolveSingle((Object)((ProfileRequestContext)Mockito.any()))).thenReturn(value);
        return resolver;
    }
}

