/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.FormOutboundAuthenticationResponseMessage;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.MessageContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FormOutboundAuthenticationResponseMessageTest
extends BaseOIDCResponseActionTest {
    private FormOutboundAuthenticationResponseMessage action;

    @BeforeMethod
    public void init() throws ComponentInitializationException, URISyntaxException {
        this.action = new FormOutboundAuthenticationResponseMessage();
        this.respCtx.setRedirectURI(new URI("http://example.org"));
        this.action.initialize();
    }

    @Test
    public void testNoRedirectUri() throws ComponentInitializationException, URISyntaxException {
        this.respCtx.setRedirectURI(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessage");
    }

    @Test
    public void testSuccessMessage() throws ComponentInitializationException, URISyntaxException, ParseException, JOSEException {
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        this.signIdTokenInResponseContext();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertTrue((boolean)(((MessageContext)this.respCtx.getParent()).getMessage() instanceof AuthenticationSuccessResponse));
    }
}

