/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientRegistrationRequest;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCRegistrationRequestTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.CheckRedirectURIs;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;
import org.mockito.Mockito;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CheckRedirectUrisTest
extends BaseOIDCRegistrationRequestTest {
    CheckRedirectURIs action;
    URI redirectUri1;
    URI redirectUri2;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException, URISyntaxException, ClientProtocolException, IOException {
        this.action = new CheckRedirectURIs();
        this.action.setHttpClient(this.buildMockHttpClient("mock"));
        this.action.initialize();
        this.redirectUri1 = new URI("https://example.org/cb1");
        this.redirectUri2 = new URI("https://example.org/cb2");
    }

    @Test
    public void testNoMessage() throws ComponentInitializationException {
        this.setUpContext(null);
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidMessageContext");
    }

    @Test
    public void testNullRedirectUris() throws ComponentInitializationException {
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        this.setUpContext(new OIDCClientRegistrationRequest(null, metadata, null));
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"MissingRedirectionURIs");
    }

    @Test
    public void testEmptyRedirectUris() throws ComponentInitializationException {
        this.assertEvent("MissingRedirectionURIs", new OIDCClientMetadata(), null);
    }

    @Test
    public void testSingleRedirectUri() throws ComponentInitializationException {
        this.assertEvent(null, new OIDCClientMetadata(), this.redirectUri1);
    }

    @Test
    public void testTwoRedirectUris() throws ComponentInitializationException {
        this.assertEvent(null, new OIDCClientMetadata(), this.redirectUri1, this.redirectUri2);
    }

    @Test
    public void testFailingSectorIdUriContents() throws Exception {
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        metadata.setSectorIDURI(new URI("https://invalid.scheme.org/cb"));
        this.initializeActionWithClient(this.buildMockHttpClient(null));
        this.assertEvent("InvalidRedirectionURIs", metadata, this.redirectUri1);
    }

    @Test
    public void testEmptySectorIdUriContents() throws Exception {
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        metadata.setSectorIDURI(new URI("https://invalid.scheme.org/cb"));
        this.initializeActionWithClient(this.buildMockHttpClient(""));
        this.assertEvent("InvalidRedirectionURIs", metadata, this.redirectUri1);
    }

    @Test
    public void testInvalidJsonSectorIdUri() throws Exception {
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        metadata.setSectorIDURI(new URI("https://invalid.scheme.org/cb"));
        this.initializeActionWithClient(this.buildMockHttpClient("Not_JSON"));
        this.assertEvent("InvalidRedirectionURIs", metadata, this.redirectUri1);
    }

    @Test
    public void testInvalidSectorIdUriContents() throws Exception {
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        metadata.setSectorIDURI(new URI("https://invalid.scheme.org/cb"));
        this.initializeActionWithClient(this.buildMockHttpClient("[ \"https://not.existing.uri.org/\" ]"));
        this.assertEvent("InvalidRedirectionURIs", metadata, this.redirectUri1);
    }

    @Test
    public void testValidSectorIdUriContents() throws Exception {
        OIDCClientMetadata metadata = new OIDCClientMetadata();
        metadata.setSectorIDURI(new URI("https://invalid.scheme.org/cb"));
        this.initializeActionWithClient(this.buildMockHttpClient("[ \"" + this.redirectUri1 + "\", \"" + this.redirectUri2 + "\" ]"));
        this.assertEvent(null, metadata, this.redirectUri1);
    }

    @Test
    public void testCheckForbiddenHostname() throws Exception {
        Assert.assertFalse((boolean)this.action.checkForbiddenHostname(Collections.singleton(new URI("custom.test:/testing")), "testing"));
        Assert.assertTrue((boolean)this.action.checkForbiddenHostname(Collections.singleton(new URI("custom.test://testing")), "testing"));
        Assert.assertTrue((boolean)this.action.checkForbiddenHostname(Collections.singleton(new URI("http://localhost")), "localhost"));
    }

    protected void initializeActionWithClient(HttpClient httpClient) throws ComponentInitializationException {
        this.action = new CheckRedirectURIs();
        this.action.setHttpClient(httpClient);
        this.action.initialize();
    }

    protected HttpClient buildMockHttpClient(String contents) throws ClientProtocolException, IOException {
        HttpClient mockClient = (HttpClient)Mockito.mock(HttpClient.class);
        if (contents == null) {
            Mockito.when((Object)mockClient.execute((HttpUriRequest)Mockito.any())).thenThrow(new Throwable[]{new IOException("mock")});
        } else {
            HttpResponse httpResponse = (HttpResponse)Mockito.mock(HttpResponse.class);
            HttpEntity httpEntity = (HttpEntity)Mockito.mock(HttpEntity.class);
            Mockito.when((Object)httpEntity.getContent()).thenReturn((Object)new ByteArrayInputStream(contents.getBytes()));
            Mockito.when((Object)httpResponse.getEntity()).thenReturn((Object)httpEntity);
            Mockito.when((Object)mockClient.execute((HttpUriRequest)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)httpResponse);
        }
        return mockClient;
    }

    protected void assertEvent(String expectedEvent, OIDCClientMetadata metadata, URI ... redirectUris) throws ComponentInitializationException {
        HashSet<URI> uris = new HashSet<URI>();
        if (redirectUris != null) {
            uris = new HashSet();
            for (URI uri : redirectUris) {
                uris.add(uri);
            }
        }
        metadata.setRedirectionURIs(uris);
        this.setUpContext(new OIDCClientRegistrationRequest(null, metadata, null));
        if (expectedEvent != null) {
            ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)expectedEvent);
        } else {
            Assert.assertNull((Object)this.action.execute(this.requestCtx));
        }
    }
}

