/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ErrorObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.shibboleth.idp.plugin.oidc.op.messaging.JSONErrorResponse;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BuildJSONErrorResponseFromEvent;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.mockito.Mockito;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BuildJSONErrorResponseFromEventTest {
    protected RequestContext requestCtx;
    protected ProfileRequestContext profileRequestCtx;
    String eventId = "mockEventId";

    protected BuildJSONErrorResponseFromEvent initializeAction(Map<String, ErrorObject> mappedErrors, String eventId) throws ComponentInitializationException {
        BuildJSONErrorResponseFromEvent action = new BuildJSONErrorResponseFromEvent();
        if (eventId != null) {
            Function function = (Function)Mockito.mock(Function.class);
            EventContext eventContext = new EventContext();
            eventContext.setEvent((Object)eventId);
            Mockito.when((Object)((EventContext)function.apply((ProfileRequestContext)Mockito.any()))).thenReturn((Object)eventContext);
            action.setEventContextLookupStrategy(function);
        }
        action.setMappedErrors(mappedErrors);
        action.initialize();
        return action;
    }

    protected BuildJSONErrorResponseFromEvent initializeAction(String eventId) throws ComponentInitializationException {
        return this.initializeAction(new HashMap<String, ErrorObject>(), eventId);
    }

    protected BuildJSONErrorResponseFromEvent initializeAction() throws ComponentInitializationException {
        return this.initializeAction(new HashMap<String, ErrorObject>(), null);
    }

    @BeforeMethod
    protected void setUpContext() throws ComponentInitializationException {
        this.requestCtx = new RequestContextBuilder().setInboundMessage(null).buildRequestContext();
        this.profileRequestCtx = new WebflowRequestContextProfileRequestContextLookup().apply(this.requestCtx);
    }

    @Test
    public void doPreExecute_shouldReturnFalseWithoutOutboundMessageContext() throws ComponentInitializationException {
        BuildJSONErrorResponseFromEvent action = this.initializeAction();
        this.profileRequestCtx.setOutboundMessageContext(null);
        Assert.assertFalse((boolean)action.doPreExecute(this.profileRequestCtx));
    }

    @Test
    public void doPreExecute_shouldReturnTrueWithOutboundMessageContext() throws ComponentInitializationException {
        BuildJSONErrorResponseFromEvent action = this.initializeAction();
        Assert.assertTrue((boolean)action.doPreExecute(this.profileRequestCtx));
    }

    @Test
    public void execute_shouldNotSetMessageWhenNoEventContext() throws ComponentInitializationException {
        BuildJSONErrorResponseFromEvent action = this.initializeAction();
        action.execute(this.requestCtx);
        Assert.assertNull((Object)this.profileRequestCtx.getOutboundMessageContext().getMessage());
    }

    @Test
    public void execute_shouldSetMessageWhenEventContext() throws ComponentInitializationException {
        BuildJSONErrorResponseFromEvent action = this.initializeAction(this.eventId);
        action.execute(this.requestCtx);
        Object rawMessage = this.profileRequestCtx.getOutboundMessageContext().getMessage();
        Assert.assertNotNull((Object)rawMessage);
        Assert.assertTrue((boolean)(rawMessage instanceof JSONErrorResponse));
        JSONErrorResponse response = (JSONErrorResponse)rawMessage;
        ErrorObject error = response.getErrorObject();
        Assert.assertEquals((String)error.getCode(), (String)"invalid_request");
        Assert.assertEquals((String)error.getDescription(), (String)this.eventId);
        Assert.assertEquals((int)error.getHTTPStatusCode(), (int)400);
    }

    @Test
    public void execute_shouldSetCustomMessageWhenConfiguredAndEventContext() throws ComponentInitializationException {
        String errorCode = "mockCode";
        String errorDescription = "mockDescription";
        int errorStatusCode = 503;
        BuildJSONErrorResponseFromEvent action = this.initializeAction(Collections.singletonMap(this.eventId, new ErrorObject(errorCode, errorDescription, errorStatusCode)), this.eventId);
        action.execute(this.requestCtx);
        Object rawMessage = this.profileRequestCtx.getOutboundMessageContext().getMessage();
        Assert.assertNotNull((Object)rawMessage);
        Assert.assertTrue((boolean)(rawMessage instanceof JSONErrorResponse));
        JSONErrorResponse response = (JSONErrorResponse)rawMessage;
        ErrorObject error = response.getErrorObject();
        Assert.assertEquals((String)error.getCode(), (String)errorCode);
        Assert.assertEquals((String)error.getDescription(), (String)errorDescription);
        Assert.assertEquals((int)error.getHTTPStatusCode(), (int)errorStatusCode);
    }
}

